<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Exporter;

use Magento\Backend\Block\Template;

/**
 * Class Exporter
 * @package FiloBlu\Refilo\Block\Exporter
 */
class Exporter extends Template
{

    /**
     * @return string
     */
    public function getSearchExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/search');
    }

    /**
     * @return string
     */
    public function getCoutriesExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/countries');
    }

    /**
     * @return string
     */
    public function getConfigExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/config');
    }

    /**
     * @return string
     */
    public function getMenuExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/menu');
    }

    /**
     * @return string
     */
    public function getUrlExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/urls');
    }

    /**
     * @return string
     */
    public function getCategoriesExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/categories');
    }

    /**
     * @return string
     */
    public function getTranslationsExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/translations');
    }

    /**
     * @return string
     */
    public function getRedirectsExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/redirects');
    }

    /**
     * @return string
     */
    public function getCmsPagesExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/cmspages');
    }

    /**
     * @return string
     */
    public function getCmsBlocksExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/cmsblocks');
    }

    /**
     * @return string
     */
    public function getContentManagerExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/contentmanager');
    }

    /**
     * @return string
     */
    public function getStoreLocatorExportUrl()
    {
        return $this->getUrl('filoblu_refilo/exporter/storelocator');
    }
}
