<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

use FiloBlu\Refilo\Helper\Indexer;
use FiloBlu\Refilo\Remote\Entity\EntityProviderInterfaceFactory;
use FiloBlu\Refilo\Remote\Helper\TemplateStringFactory;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterfaceFactory;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerResolver;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Zend_Db_Exception;

/**
 * Class CatalogProductIndexer
 * @package FiloBlu\Refilo\Remote
 */
class ProductIndexer extends AbstractStoreBasedIndexer
{
    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }

    /**
     * @param $entities
     * @param $collection
     * @throws NoSuchEntityException
     */
    public function write($entities, $collection)
    {
        $this->getConnector()->create(
            $this->getIndexerHelper()->hideOutOfStocks(
            $entities,
            $this->getStoreManager()->getStore()
        ), $collection);
    }
}
