<?php

namespace FiloBlu\Refilo\Remote\IndexerConfiguration;

use FiloBlu\Core\Framework\Model\RepositoryItem;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;

/**
 * Interface IndexerConfigurationInterface
 * @package FiloBlu\Refilo\Remote
 */
interface IndexerConfigurationInterface extends RepositoryItem
{
    /** @var string */
    const ID = 'id';
    /** @var string */
    const CONNECTOR_CONFIGURATION = 'connector_configuration';
    /** @var string */
    const INDEXER_ID = 'indexer_id';
    /** @var string */
    const INDEX_NAME = 'index_name';
    /** @var string */
    const CONFIGURATION = 'configuration';
    /** @var string  */
    const ENABLED = 'enabled';
    /**
     * @return ConnectorConfigurationInterface
     */
    public function getConnectorConfiguration(): ?ConnectorConfigurationInterface;

    /**
     * @return bool
     */
    public function hasConnectorConfiguration() : bool;
    /**
     * @return string
     */
    public function getIndexName();

    /**
     * @param string $name
     * @return IndexerConfigurationInterface
     */
    public function setIndexName(string $name): IndexerConfigurationInterface;

    /**
     * @return string|null
     */
    public function getIndexerId();

    /**
     * @param string $id
     * @return IndexerConfigurationInterface
     */
    public function setIndexerId(string $id): IndexerConfigurationInterface;

    /**
     * @param \FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface|null $connectorConfiguration
     * @return IndexerConfigurationInterface
     */
    public function setConnectorConfiguration(?ConnectorConfigurationInterface $connectorConfiguration): IndexerConfigurationInterface;


    /**
     * @param $enable
     * @return IndexerConfigurationInterface
     */
    public function setEnabled($enable) : IndexerConfigurationInterface;

    /**
     * @return bool
     */
    public function getEnabled();
}
