<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins;

use Magento\Framework\Module\Manager;
use Magento\Indexer\Model\Config\Data;

/**
 *
 */
class DisableCategoryPermissionIfNotEnabled
{

    /**
     * @var \Magento\Framework\Module\Manager
     */
    private $moduleManager;

    /**
     * @param \Magento\Framework\Module\Manager $moduleManager
     */
    public function __construct(Manager $moduleManager)
    {
        $this->moduleManager = $moduleManager;
    }

    /**
     * @param \Magento\Indexer\Model\Config\Data $subject
     * @param $data
     * @param $path
     * @param $default
     * @return mixed
     */
    public function afterGet(
        Data $subject,
        $data,
        $path = null,
        $default = null
    ) {
        if ($this->shouldRemoveIndex()) {
            unset($data['beehive_category_permissions']);
        }

        return $data;
    }

    /**
     * @return bool
     */
    public function shouldRemoveIndex() :bool
    {
        if (!$this->moduleManager->isEnabled('Magento_CatalogPermissions')) {
            return true;
        }

        return false;
    }

}
