<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface;
use FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface;
use Magento\Framework\DataObject;

/**
 *
 */
class ProductCustomOption extends DataObject implements ProductCustomOptionInterface
{

    /**
     * @return int
     */
    public function getId(): int
    {
        return (int)$this->_getData(self::ID);
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->_getData(self::TYPE);
    }

    /**
     * @return bool
     */
    public function getRequired() :bool
    {
        return (bool)$this->_getData(self::REQUIRED);
    }

    public function getSku()
    {
        return $this->_getData(self::SKU);
    }

    public function getMaxCharacters()
    {
        return $this->_getData(self::MAX_CHARACTERS);
    }

    public function getCode()
    {
        return $this->_getData(self::CODE);
    }

    public function getLabel()
    {
        return $this->_getData(self::LABEL);
    }

    /**
     * @return float
     */
    public function getPrice() : float
    {
        return (float)$this->_getData(self::PRICE);
    }

    /**
     * @return mixed
     */
    public function getFileExtensions()
    {
        return $this->_getData(self::FILE_EXTENSIONS);
    }

    /**
     * @return int
     */
    public function getImageSizeX()
    {
        return $this->_getData(self::IMAGE_SIZE_X);
    }

    /**
     * @return int
     */
    public function getImageSizeY()
    {
        return $this->_getData(self::IMAGE_SIZE_Y);
    }

    /**
     * @param $id
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setId($id): ProductCustomOptionInterface
    {
        return $this->setData(self::ID, $id);
    }

    /**
     * @param string $type
     * @return ProductCustomOptionInterface
     */
    public function setType(string $type) : ProductCustomOptionInterface
    {
        return $this->setData(self::TYPE, $type);
    }

    public function setRequired(bool $required): ProductCustomOptionInterface
    {
        return $this->setData(self::REQUIRED, $required);
    }

    public function setSku(?string $sku): ProductCustomOptionInterface
    {
        return $this->setData(self::SKU, $sku);
    }

    /**
     * @param int $maxCharacters
     * @return ProductCustomOptionInterface
     */
    public function setMaxCharacters($maxCharacters): ProductCustomOptionInterface
    {
        return $this->setData(self::MAX_CHARACTERS, $maxCharacters);
    }

    /**
     * @param string $code
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setCode($code): ProductCustomOptionInterface
    {
        return $this->setData(self::CODE, $code);
    }

    /**
     * @param string|null $label
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setLabel(?string $label): ProductCustomOptionInterface
    {
        return $this->setData(self::LABEL, $label);
    }

    /**
     * @param float $price
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setPrice(float $price): ProductCustomOptionInterface
    {
        return $this->setData(self::PRICE, $price);
    }

    /**
     * @param array $fileExtensions
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setFileExtensions($fileExtensions): ProductCustomOptionInterface
    {
        return $this->setData(self::FILE_EXTENSIONS, $fileExtensions);
    }

    /**
     * @param int $imageSizeX
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setImageSizeX($imageSizeX): ProductCustomOptionInterface
    {
        return $this->setData(self::IMAGE_SIZE_X, $imageSizeX);
    }

    /**
     * @param $imageSizeY
     * @return \FiloBlu\Refilo\Model\ProductCustomOption
     */
    public function setImageSizeY($imageSizeY): ProductCustomOptionInterface
    {
        return $this->setData(self::IMAGE_SIZE_Y, $imageSizeY);
    }

    /**
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface $value
     * @return self
     */
    public function addValue(ProductCustomOptionValueInterface $value): ProductCustomOptionInterface
    {
        $values = $this->getValues();
        $values[] = $value;
        return $this->setValues($values);
    }

    /**
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface[]
     */
    public function getValues()
    {
        return $this->_getData(self::VALUES) ?? [];
    }

    /**
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface[] $values
     * @return ProductCustomOptionInterface
     */
    public function setValues($values): ProductCustomOptionInterface
    {
        return $this->setData(self::VALUES, $values);

    }
}