<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Helper;

/**
 * Class Profiler
 */
class Profiler
{
    /**
     * @var int
     */
    protected static $level = 0;

    /**
     * @param $section
     */
    public static function start($section)
    {
        echo str_repeat(' ', self::$level), $section, ' : ';
        self::memoryUsage();
        self::$level++;
    }

    /**
     *
     */
    public static function memoryUsage()
    {
        $usage = memory_get_usage(true);

        if ($usage < 1024) {
            echo "$usage bytes", PHP_EOL;
        } elseif ($usage < 1048576) {
            echo round($usage / 1024, 2), ' Kb', PHP_EOL;
        } else {
            echo round($usage / 1048576, 2), ' Mb', PHP_EOL;
        }

    }

    /**
     * @param $section
     */
    public static function stop($section)
    {
        self::$level--;
        echo str_repeat(' ', self::$level), $section, ' : ';
        self::memoryUsage();
    }
}
