<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Redirects;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportRedirects extends Command
{
    const NAME = 'name';
    /**
     * @var Redirects
     */
    private $redirects;


    /**
     * ImportBlocks constructor.
     * @param Redirects $redirects
     * @param string $name
     */
    public function __construct(
        Redirects $redirects,
        string $name = null
    ) {
        $this->redirects = $redirects;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:redirects');
        $this->setDescription('Import Redirects');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->redirects->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
