<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Option;

use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class ProductAttributeOptionSource
 */
class ProductAttributeOptionSource implements OptionSourceInterface
{
    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;

    /**
     * @var null
     */
    protected $options = null;

    /**
     * ProductAttributeOptionSource constructor.
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(
        CollectionFactory $collectionFactory
    )
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        if ($this->options === null) {
            $this->options = [
                [
                    'value' => null,
                    'label' => ''
                ]
            ];
            foreach ($this->collectionFactory->create() as $attribute) {
                $this->options[] = [
                    'value' => $attribute->getAttributeCode(),
                    'label' => $attribute->getStoreLabel()
                ];

            }
        }

        return $this->options;
    }
}
