<?php


namespace FiloBlu\Referrals\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function upgrade(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        if (version_compare($context->getVersion(), "1.0.1", "<")) {
            $this->addCouponColumnToInvitation($setup, $context);
        }

        if (version_compare($context->getVersion(), '1.0.2', '<')) {
            $this->addGeneratedByReferralToCoupons($setup, $context);
        }

        if (version_compare($context->getVersion(), "1.0.3", "<")) {
            $this->addSentCouponColumnToInvitation($setup, $context);
        }

        if (version_compare($context->getVersion(), "1.0.4", "<")) {
            $this->addNewletterReferralIdColumnToInvitation($setup, $context);
            $this->addFiloBluNewsletterInvitationTrackTable($setup, $context);
        }

    }

    public function addCouponColumnToInvitation(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        $eavTable = $installer->getTable('magento_invitation');

        $columns = [
            'coupon_for_who_got_invited' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'nullable' => true,
                'LENGTH' => 100,
                'default' => null,
                'comment' => 'Coupon code for who got invited'
            ],
            'coupon_for_who_sent_the_invite' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'nullable' => true,
                'LENGTH' => 100,
                'default' => null,
                'comment' => 'Coupon code for who sent the invite'
            ]
        ];

        $connection = $installer->getConnection();
        foreach ($columns as $name => $definition) {
            $connection->addColumn($eavTable, $name, $definition);
        }

        $installer->endSetup();
    }


    public function addGeneratedByReferralToCoupons(SchemaSetupInterface $setup, ModuleContextInterface $context) {
        $installer = $setup;
        $installer->startSetup();

        $eavTable = $installer->getTable('salesrule_coupon');

        $columns = [
            'generated_by_invitation_referral' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                'nullable' => true,
                'default' => null,
                'comment' => '1 = Generated by invitation referral'
            ]
        ];

        $connection = $installer->getConnection();
        foreach ($columns as $name => $definition) {
            $connection->addColumn($eavTable, $name, $definition);
        }

        $installer->endSetup();

    }

    public function addSentCouponColumnToInvitation(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        $eavTable = $installer->getTable('magento_invitation');

        $columns = [
            'who_got_invited_cp_sent' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                'nullable' => false,
                'LENGTH' => 1,
                'default' => 0,
                'comment' => 'Boolean to keep track of the email sent'
            ],
            'who_sent_the_invite_cp_sent' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_SMALLINT,
                'nullable' => false,
                'LENGTH' => 1,
                'default' => 0,
                'comment' => 'Boolean to keep track of the email sent'
            ]
        ];

        $connection = $installer->getConnection();
        foreach ($columns as $name => $definition) {
            $connection->addColumn($eavTable, $name, $definition);
        }

        $installer->endSetup();
    }

    public function addNewletterReferralIdColumnToInvitation(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        $eavTable = $installer->getTable('magento_invitation');

        $columns = [
            'newsletter_referral_id' => [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                'nullable' => true,
                'LENGTH' => 10,
                'default' => null,
                'comment' => 'Coupon code for who got invited'
            ]
        ];

        $connection = $installer->getConnection();
        foreach ($columns as $name => $definition) {
            $connection->addColumn($eavTable, $name, $definition);
        }

        $installer->endSetup();
    }

    public function addFiloBluNewsletterInvitationTrackTable(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        if (!$installer->tableExists('filoblu_newsletter_invitation_track')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('filoblu_newsletter_invitation_track'))
                ->addColumn(
                    'track_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'Track Id'
                )->addColumn(
                    'inviter_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'default' => '0'],
                    'Inviter Id'
                )->addColumn(
                    'referral_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'default' => '0'],
                    'Referral Id'
                )->setComment(
                    'Newsletter Invitation Track'
                )->addIndex(
                    $installer->getIdxName(
                        'filoblu_newsletter_invitation_track',
                        ['inviter_id', 'referral_id'],
                        \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE
                    ),
                    ['inviter_id', 'referral_id'],
                    ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                );
            $installer->getConnection()->createTable($table);
        }

        $installer->endSetup();
    }
}
