<?php


namespace FiloBlu\Referrals\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class InstallSchema implements InstallSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function install(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        //Your install script
        $this->addNewletterReferralIdColumnToInvitation($setup, $context);
        $this->addFiloBluNewsletterInvitationTrackTable($setup, $context);

    }

    public function addNewletterReferralIdColumnToInvitation(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        $eavTable = $installer->getTable('magento_invitation');

        $connection = $installer->getConnection();

        if ($connection->tableColumnExists('magento_invitation', 'newsletter_referral_id') === false) {

            $columns = [
                'newsletter_referral_id' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER ,
                    'nullable' => true ,
                    'LENGTH' => 10 ,
                    'default' => null ,
                    'comment' => 'Coupon code for who got invited'
                ]
            ];


            foreach ($columns as $name => $definition) {
                $connection -> addColumn($eavTable , $name , $definition);
            }

        }
        
        $installer -> endSetup();
    }

    public function addFiloBluNewsletterInvitationTrackTable(SchemaSetupInterface $setup, ModuleContextInterface $context) {

        $installer = $setup;
        $installer->startSetup();

        if (!$installer->tableExists('filoblu_newsletter_invitation_track')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('filoblu_newsletter_invitation_track'))
                ->addColumn(
                    'track_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'Track Id'
                )->addColumn(
                    'inviter_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'default' => '0'],
                    'Inviter Id'
                )->addColumn(
                    'referral_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'default' => '0'],
                    'Referral Id'
                )->setComment(
                    'Newsletter Invitation Track'
                )->addIndex(
                    $installer->getIdxName(
                        'filoblu_newsletter_invitation_track',
                        ['inviter_id', 'referral_id'],
                        \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE
                    ),
                    ['inviter_id', 'referral_id'],
                    ['type' => \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_UNIQUE]
                );
            $installer->getConnection()->createTable($table);
        }

        $installer->endSetup();
    }
}
