<?php

namespace FiloBlu\Referrals\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Eav\Model\Entity\Attribute\SetFactory as AttributeSetFactory;

class InstallData implements InstallDataInterface
{
    protected $customerSetupFactory;
    private $attributeSetFactory;

    public function __construct(
        CustomerSetupFactory $customerSetupFactory,
        AttributeSetFactory $attributeSetFactory
    )
    {
        $this->customerSetupFactory = $customerSetupFactory;
        $this->attributeSetFactory = $attributeSetFactory;
    }

    public function install(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    )
    {
        $setup->startSetup();
        $customerSetup = $this->customerSetupFactory->create(['setup' => $setup]);

        $customerEntity = $customerSetup->getEavConfig()->getEntityType('customer');
        $attributeSetId = $customerEntity->getDefaultAttributeSetId();

        $attributeSet = $this->attributeSetFactory->create();
        $attributeGroupId = $attributeSet->getDefaultGroupId($attributeSetId);

        $customerSetup->addAttribute(\Magento\Customer\Model\Customer::ENTITY, 'referral_code', [
            'type'         => 'varchar',
            'label'        => 'Referral Code',
            'input'        => 'text',
            'source'       => '',
            'required'     => false,
            'visible'      => true,
            'user_defined' => true,
            'sort_order'   => 999,
            'position'     => 999,
            'system'       => false,
            'unique'       => true
        ]);

        $referral_attr = $customerSetup->getEavConfig()->getAttribute(\Magento\Customer\Model\Customer::ENTITY, 'referral_code')
            ->addData([
                'attribute_set_id' => $attributeSetId,
                'attribute_group_id' => $attributeGroupId,
                # 'used_in_forms' => ['adminhtml_customer', 'customer_account_create', 'customer_account_edit'],
                # The referral_code can't be modified by anyone!
                'used_in_forms' => ['adminhtml_customer'],
            ]);

        $referral_attr->save();
        $setup->endSetup();
    }
}
