<?php

namespace FiloBlu\Referrals\Plugin;


use FiloBlu\Referrals\Helper\Core;
use FiloBlu\Referrals\Helper\Rule;
use FiloBlu\Referrals\Model\Invitation;
use Magento\Framework\Registry;
use Magento\Invitation\Model\ResourceModel\Invitation\CollectionFactory as InvitationCollectionFactory;

class UtilityPlugin
{
    /**
     * @var Rule
     */
    protected $ruleHelper;
    /**
     * @var Core
     */
    protected $referralHelper;
    /**
     * @var Registry
     */
    private $registry;
    /**
     * @var InvitationCollectionFactory
     */
    private $invitationFactory;

    /**
     * @param Core $referralHelper
     * @param Rule $ruleHelper
     * @param Registry $registry
     * @param InvitationCollectionFactory $invitationFactory
     */
    public function __construct(
        Core                        $referralHelper,
        Rule                        $ruleHelper,
        Registry                    $registry,
        InvitationCollectionFactory $invitationFactory
    )
    {
        $this->ruleHelper = $ruleHelper;
        $this->referralHelper = $referralHelper;
        $this->registry = $registry;
        $this->invitationFactory = $invitationFactory;
    }

    /*
     * This is needed because ONLY the user receiving a coupon from an invitation can use THAT coupon
     * That coupon is not shareable!
     */
    public function afterCanProcessRule($utility, $result, $rule, $address)
    {
        //check if module is active
        if (!$this->referralHelper->isEnabled()) {
            return $result;
        }

        //check if coupon was used yet
        $coupon = $this->referralHelper->getCuponInfo($rule->getCode());

        if (!$this->referralHelper->isInvitationalTypeCoupon($rule->getCode())) {
            return $result;
        }

        if (!$rule->getCode()) {
            return $result;
        }

        if ($coupon->getTimesUsed() > 0) {
            return false;
        }

        if ($this->registry->registry('fb_referral_customer_id')) {
            return $result;
        }

        if ($address->getCustomerId()) {
            $customerId = $address->getCustomerId();
            /** @var Invitation $invitation */
            $invitation = $this->referralHelper->getInvitationByCouponCode($rule->getCode());
        }

        if(!isset($invitation) || !isset($customerId)){
            return $result;
        }

        $customerIsSender = false;
        $customerIsReceiver = false;

        if ($customerId && $invitation->getCustomerId() == $customerId){
            $this->referralHelper->writeLog("COUPON PLUGIN: The customer is sender");
            $customerIsSender = true;
        }

        if ($customerId && !$customerIsSender &&  $invitation->getReferralId() == $customerId) {
            $this->referralHelper->writeLog("COUPON PLUGIN: The customer is receiver");
            $customerIsReceiver = true;
        }

        if($customerIsSender){
            return $invitation->getData('coupon_for_who_sent_the_invite') == $rule->getCode();
        }

        if($customerIsReceiver){
            return $invitation->getData('coupon_for_who_got_invited') == $rule->getCode();
        }

        //check if current cuopon is a referrall coupon
        return $this->ruleHelper->canApplyRule($rule);
    }

}
