<?php
declare(strict_types=1);

namespace FiloBlu\Referrals\Plugin\Refilo;

use FiloBlu\InvitationExtension\Api\InvitationManagementInterface;
use FiloBlu\Referrals\Helper\Refilo\CouponHelper;

class AfterAcceptedInvitation
{
    /**
     * @var CouponHelper
     */
    private $helper;

    /**
     * @param CouponHelper $helper
     */
    public function __construct(
        CouponHelper $helper
    )
    {
        $this->helper = $helper;
    }

    public function afterAcceptInvitation(InvitationManagementInterface $subject, $result, $invitationCode, $customerId)
    {
        $this->helper->generateCoupon($customerId);
        $this->helper->sendEmailToReceiver($customerId);

        return $result;
    }


}
