<?php


namespace FiloBlu\Referrals\Plugin\Magento\Invitation\Model;

use Magento\Invitation\Model\Invitation\Status;

class Invitation
{
    /**
     * @var \FiloBlu\Referrals\Helper\Email
     */
    protected $_referralEmail;

    /**
     * @var \FiloBlu\Referrals\Helper\Core
     */
    protected $_coreHelper;

    /**
     * @var \Magento\Newsletter\Model\SubscriberFactory
     */
    protected $_subscriberFactory;

    public function __construct(
        \FiloBlu\Referrals\Helper\Email $referralEmail,
        \FiloBlu\Referrals\Helper\Core $coreHelper,
        \Magento\Newsletter\Model\SubscriberFactory $subscriberFactory
    )
    {
        $this->_referralEmail = $referralEmail;
        $this->_coreHelper = $coreHelper;
        $this->_subscriberFactory = $subscriberFactory;
    }

    /**
     * @param \Magento\Invitation\Model\Invitation $subject
     * @param $result
     * @param $websiteId
     * @param $referralId
     * @return mixed
     * @throws \Exception
     */
    public function afterAccept(
        \Magento\Invitation\Model\Invitation $subject,
        $result,
        $websiteId,
        $referralId
    ) {
        $status_accepted = Status::STATUS_ACCEPTED;
        $status = $result->getStatus();
        if ($status == $status_accepted){


            $couponInvitationType = $this->_coreHelper->getSysConfigValue($this->_coreHelper::COUPON_FIELD_INVITATION_TYPE);

            if ($couponInvitationType !== 'site') {
                try {
                    $subscriber = $this->_subscriberFactory->create()->loadByEmail($subject->getEmail());
                    $subject->setNewsletterReferralId($subscriber->getSubscriberId());
                    $subject->save();

                } catch (\Exception $exception) {
                    throw new \Exception("INVITATION ID {$subscriber->getId()}: Unable to save newsletter referral id {$subscriber->getSubscriberId()}");
                }

                $this->_referralEmail->notify_invitation_receiver_by_newsletter_referral_id($subject->getSubscriberId());

            } else {
                $this->_referralEmail->notify_invitation_receiver_by_referral_id($referralId);
            }
        }
        return $result;
    }
}