<?php

namespace FiloBlu\Referrals\Plugin;

class InvitationPlugin
{
    const RULE_ID_SENDER_OF_THE_INVITE = 'filoblu_referrals/general/ruleidsender';
    const RULE_ID_RECEIVER_OF_THE_INVITE = 'filoblu_referrals/general/ruleidreceiver';

    protected $_referralHelper;
    protected $_emailHelper;
    protected $ruleCollectionFactory;
    protected $_customerRepositoryInterface;

    protected $_storeManager;

    public function __construct(
        \FiloBlu\Referrals\Helper\Core $referralHelper,
        \Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory $ruleCollectionFactory,
        \FiloBlu\Referrals\Helper\Email $emailHelper,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepositoryInterface,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        $this->_referralHelper = $referralHelper;
        $this->ruleCollectionFactory = $ruleCollectionFactory;
        $this->_emailHelper = $emailHelper;
        $this->_customerRepositoryInterface = $customerRepositoryInterface;
        $this->_storeManager = $storeManager;
    }

    public function afterSendInvitationEmail(\Magento\Invitation\Model\Invitation $invitation, $result){

        // Not enabled, skip!
        if (!$this->_referralHelper->isEnabled()){
            $this->_referralHelper->writeLog("FiloBlu\Referrals Module not enabled!");
            return $result;
        }

        // Email was not sent!
        if(!$result){
            $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} There was a problem sending the first email!" );
            return $result;
        }

        $sender_db_field = $this->_referralHelper->getCouponDbFieldNameForWhoSentTheInvite();
        $receiver_db_field = $this->_referralHelper->getCouponDbFieldNameForWhoGotInvited();

        $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Success: the customer ID {$invitation->getCustomerId()} invited {$invitation->getEmail()} | preparing the coupons!");

        // Generating and saving the coupon code (magento_invitation table) for the user that send the invite
        $rule_id = $this->_referralHelper->getSysConfigValue(self::RULE_ID_SENDER_OF_THE_INVITE,'store',$this->_storeManager->getStore()->getId());
        $rule_loaded = $this->loadSalesRuleById($rule_id);
        if($rule_loaded && $rule_loaded->getRuleId()){
            $coupon_code_generated = $this->_referralHelper->generateCoupon($rule_loaded->getRuleId());
            if($coupon_code_generated){
                $invitation->setData($sender_db_field, $coupon_code_generated);
                $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Success: generated the coupon {$coupon_code_generated} for ".$sender_db_field);
            } else {
                $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Error: Coupon for ".$sender_db_field." NOT generated!");
            }
        } else {
            $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Error: Salesrule ID ".$rule_id." NOT found!");
        }

        // Generating and saving the coupon code (magento_invitation table) for the user that is invited
        $rule_id = $this->_referralHelper->getSysConfigValue(self::RULE_ID_RECEIVER_OF_THE_INVITE,'store',$this->_storeManager->getStore()->getId());
        $rule_loaded = $this->loadSalesRuleById($rule_id);
        if($rule_loaded && $rule_loaded->getRuleId()){
            $coupon_code_generated = $this->_referralHelper->generateCoupon($rule_loaded->getRuleId());
            if($coupon_code_generated){
                $invitation->setData($receiver_db_field, $coupon_code_generated);
                $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Success: generated the coupon {$coupon_code_generated} for ".$receiver_db_field);
            } else {
                $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Error: Coupon for ".$receiver_db_field." NOT generated!");
            }
        } else {
            $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Error: Salesrule ID ".$rule_id." NOT found!");
        }

        $invitation->save();
        $this->_referralHelper->writeLog("INVITATION ID {$invitation->getInvitationId()} Success: saved!" );

        return $result;

    }

    protected function loadSalesRuleByName($name){
        $collection = $this->ruleCollectionFactory->create();
        $collection->addFieldToSelect("*");
        $collection->addFieldToFilter('name', $name);

        if($collection->getSize()){
            $rule_found = $collection->getFirstItem();
            return $rule_found;
        } else {
            return false;
        }
    }

    protected function loadSalesRuleById($id = null){

        if(!$id || !is_numeric($id)){
            return false;
        }

        $collection = $this->ruleCollectionFactory->create();
        $collection->addFieldToSelect("*");
        $collection->addFieldToFilter('rule_id', $id);

        if($collection->getSize()){
            $rule_found = $collection->getFirstItem();
            return $rule_found;
        } else {
            return false;
        }
    }

}