<?php

namespace FiloBlu\Referrals\Plugin\FiloBlu\Newsletter\Model;

use FiloBlu\Referrals\Helper\Core;

class Subscriber
{
    /**
     * @var Core
     */
    protected $coreHelper;

    /**
     * @param Core $coreHelper
     */
    public function __construct(
        Core $coreHelper
    )
    {
        $this->coreHelper = $coreHelper;
    }

    /**
     * @param \FiloBlu\Newsletter\Model\Subscriber $subscriber
     * @return null
     */
    public function beforeSendConfirmationSuccessEmail(\FiloBlu\Newsletter\Model\Subscriber $subscriber) {

        if (!$subscriber->hasData('is_referral')) {
            return null;
        }

        $this->coreHelper->writeLog(sprintf('The subscriber %s is a referral', $subscriber->getEmail()));

        if (!$this->coreHelper->isSubscriberWelcomeEmailEnabled()) {
            $this->coreHelper->writeLog('Welcome mail is diabled');
             $subscriber->setImportMode(true);
        }

        return null;

    }
}