<?php

namespace FiloBlu\Referrals\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Newsletter\Model\SubscriberFactory;

class SalesOrderAfterSave implements ObserverInterface
{
    const ORDER_STATUSES_TO_BE_MONITORED = 'filoblu_referrals/general/referral_order_statuses_to_monitor';
    const WHEN_SEND_COUPON_TO_SENDER = 'filoblu_referrals/general/when_send_coupon_to_sender';

    /**
     * @var \FiloBlu\Referrals\Helper\Core
     */
    protected $_referralHelper;

    /**
     * @var \FiloBlu\Referrals\Helper\Email
     */
    protected $_emailHelper;

    /**
     * @var SubscriberFactory
     */
    protected $subscriberFactory;


    public function __construct(
        \FiloBlu\Referrals\Helper\Core $referralHelper,
        \FiloBlu\Referrals\Helper\Email $emailHelper,
        SubscriberFactory $subscriberFactory
    ) {
        $this->_referralHelper = $referralHelper;
        $this->_emailHelper = $emailHelper;
        $this->subscriberFactory = $subscriberFactory;
    }

    /**
     * After save observer for order
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {

        $order = $observer->getEvent()->getOrder();

        // The module referral is not enabled, no need to go forward!
        if (!$this->_referralHelper->isEnabled($order->getStoreId())){
            //$this->_referralHelper->writeLog("FiloBlu\Referrals Module not enabled!");
            return;
        }

        $when_send_coupon_to_sender = $this->_referralHelper->getSysConfigValue(self::WHEN_SEND_COUPON_TO_SENDER);
        if($when_send_coupon_to_sender != 'order_enters_magento') {
            return;
        }

        $status = $order->getStatus();
        $allowed_order_statuses_to_be_monitored = $this->_referralHelper->getSysConfigValue(self::ORDER_STATUSES_TO_BE_MONITORED);
        $allowed_order_statuses_to_be_monitored = explode(',',$allowed_order_statuses_to_be_monitored);

        // Monitoring only the statuses I want
        if(in_array($status,$allowed_order_statuses_to_be_monitored)){

            $couponInvitationType = $this->_referralHelper->getSysConfigValue($this->_referralHelper::COUPON_FIELD_INVITATION_TYPE);

            $field = 'referral_id';
            $refereeId = $order->getCustomerId();
            if ($couponInvitationType != 'newsletter') {
                $invited_by = $this->_referralHelper->whoInvitedCustomerId($order->getCustomerId());
            } else {

                $customerEmail = $order->getCustomerEmail();

                $subscriber = $this->subscriberFactory->create()->load($customerEmail, 'subscriber_email');

                $field = 'newsletter_referral_id';
                $refereeId = $subscriber->getSubscriberId();

                $invited_by = $this->_referralHelper->whoInvitedCustomerId($subscriber->getSubscriberId(), true);
            }


            $this->_referralHelper->writeLog("COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | customer_id {$order->getCustomerId()} | invited_by {$invited_by}");

            // If the user have not been invited by anyone stop here
            if(!$invited_by){
                return;
            }

            $invitations_of_this_user = $this->_referralHelper->getInvitationByDbField($field, $refereeId,false);

            $this->_referralHelper->writeLog("COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | Invitations found {$invitations_of_this_user->getSize()}");

            // If the user have no invitations stop here
            if ($invitations_of_this_user->getSize() == 0){
                return;
            }

            // Reading all his invitations (should be always only one!)
            // One user can be invited only one time
            foreach ($invitations_of_this_user as $invitation) {
                // Check if already sent
                /*
                 * Fix for task ARSFB8-508
                 * You can use more than one 'Invite Friend' coupon
                 */
                if($invitation->getWhoSentTheInviteCpSent() != 1 && $invitation->getStatus() == 'accepted'){

                    if ($couponInvitationType === 'newsletter') {

                        $shippingAddress = $order->getShippingAddress();

                        $invitation->setCustomerFirstname($shippingAddress->getFirstname());
                        $invitation->setCustomerLastname($shippingAddress->getLastname());
                    }

                    // Sending the coupon to who invited this customer
                    $result = $this->_emailHelper->notify_invitation_sender($invitation);
                    $this->_referralHelper->writeLog("COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | Sending coupon to the sender of invitation_id {$invitation->getInvitationId()}");
                    if($result){
                        $this->_referralHelper->writeLog("COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | Sended coupon!");
                        $invitation->setWhoSentTheInviteCpSent(1);
                        $invitation->save();
                    }
                    break;
                }
            }

        }

        return;
    }
}
