<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 17/07/19
 * Time: 14.23
 */

namespace FiloBlu\Referrals\Observer;


class ReferralConditionObserver implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $additional = $observer->getAdditional();
        $conditions = (array)$additional->getConditions();

        // Merging the old condition with our condition.
        $conditions = array_merge_recursive($conditions, [
            [
                'value'=> [
                    [
                        'value' => \FiloBlu\Referrals\Model\Rule\Condition\Customer\Referral::class,
                        'label' => __('Customer Referral')
                    ]
                ], 'label'=> __('Coupon Limit')
            ]
        ]);

        $additional->setConditions($conditions);
    }


}