<?php

namespace FiloBlu\Referrals\Observer;

use FiloBlu\Referrals\Helper\Core;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class CustomerCreatePost implements ObserverInterface
{

    /**
     * @var Core
     */
    protected $coreHelper;

    public function __construct(
        Core $coreHelper
    ) {
        $this->coreHelper = $coreHelper;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        if (!$this->coreHelper->isEnabled()) {
            return;
        }

        $customer = $observer->getEvent()->getCustomer();

        $invitation = $this->coreHelper->getInvitationByDbField('email', $customer->getEmail());

        if (!$invitation) {
            return;
        }

        if (!$invitation->getInvitationId()) {
            return;
        }

        $invitation->setReferralId($customer->getId())->save();
    }
}