<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 17/07/19
 * Time: 14.26
 */

namespace FiloBlu\Referrals\Model\Rule\Condition\Customer;

use Amasty\Promo\Block\Add;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Message\ManagerInterface;
use Magento\SalesRule\Model\Coupon;
use Magento\Quote\Model\Quote\Address;
use Magento\Checkout\Model\Session;

class Referral extends \Magento\Rule\Model\Condition\AbstractCondition
{

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $orderFactory;
    protected $request;
    protected $manager;
    protected $coupon;
    protected $address;
    protected $checkoutSession;


    /**
     * Referral constructor.
     * @param \Magento\Rule\Model\Condition\Context $context
     * @param CollectionFactory $orderFactory
     * @param RequestInterface $request
     * @param ManagerInterface $manager
     * @param Coupon $coupon
     * @param Address $address
     * @param Session $checkoutSession
     * @param array $data
     */
    public function __construct(
        \Magento\Rule\Model\Condition\Context $context,
        CollectionFactory $orderFactory,
        RequestInterface $request,
        ManagerInterface $manager,
        Coupon $coupon,
        Address $address,
        Session $checkoutSession,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->orderFactory = $orderFactory;
        $this->request = $request;
        $this->manager = $manager;
        $this->coupon = $coupon;
        $this->address = $address;
        $this->checkoutSession = $checkoutSession;
    }
    /**
     * Load attribute options
     *
     * @return $this
     */
    public function loadAttributeOptions()
    {
        $attributes = [
            'coupon_limit' => __("Coupon Usage Limit")
        ];
        $this->setAttributeOption($attributes);
        return $this;
    }
    /**
     * Get input type
     * Possible values are: string, numeric, date, select, multiselect, grid, boolean
     *
     * @return string
     */
    public function getInputType()
    {
        return 'string';
    }
    /**
     * Get value element type
     *
     * We have the value element types as select, text
     * @return string
     */
    public function getValueElementType()
    {
        return 'text';
    }


    /**
     * @param \Magento\Framework\Model\AbstractModel $model
     * @return bool
     */
    public function validate(\Magento\Framework\Model\AbstractModel $model)
    {

        //check if coupon belongs to this rule
        $coupon [] = $this->request->getParam('last_code') ?? '';
        if($this->request->getMethod() ==  'PUT')
        {
            try
            {
                $coupon = explode(",",urldecode(explode("coupons/",$this->request->getPathInfo())[1]));
            }
            catch (\Exception $e)
            {
                $this->manager->addErrorMessage($e);
            }
        }


        $modelRuleId = $this->getRule()->getRuleId();

        foreach ($coupon as $code)
        {


            $ruleId = $this->coupon->loadByCode($code)->getRuleId();

            if ($ruleId == $modelRuleId)
            {
                $allCodes = $this->request->getParam('coupon_code') ?? '';
                // Get the current customer id
                $customerId = (int)$model->getCustomerId();
                try
                {
                    $order = $this->orderFactory->create($customerId);

                    $all_orders = $order->getItems();
                    $usedCoupons = [];
                    foreach ($order->getItems() as $item)
                    {
                        $temp = explode(",", $item->getCouponCode());
                        $usedCoupons = array_merge($usedCoupons, $temp);
                    }


                    $codeUsage = 0;
                    foreach ($usedCoupons as $val)
                    {
                        if ($val == $code)
                        {
                            $codeUsage++;
                        }
                    }
                    //set $val and compare with rule condition setting
                    $model->setData('coupon_limit', $codeUsage);
                    if (!parent::validate($model)) {
                        $allCodesArray = explode(",", $allCodes);
                        $allCodes = implode(",", array_diff($allCodesArray, array($code)));
                        $this->request->setParams(['coupon_code' => $allCodes]);
                        $this->checkoutSession->getQuote()->setCouponCode($allCodes);
                        $this->manager->addErrorMessage("$code - is already used!");
                    }

                    //return parent::validate($model);
                    //you have to return always true. If you return false Magento will remove all coupons belonging to that ruleId
                    return true;
                }
                catch (\Exception $e)
                {
                    $this->manager->addErrorMessage($e);
                }
            }
            else
            {
                return true;
            }
        }
    }
}