<?php

namespace FiloBlu\Referrals\Model\ResourceModel;

class Invitation extends \Magento\Invitation\Model\ResourceModel\Invitation
{
    /**
     * Save invitation tracking info
     *
     * @param int $inviterId
     * @param int $referralId
     * @return void
     * @throws \Exception
     */
    public function trackNlSubscriptionReferral($inviterId, $referralId)
    {
        try {
            $data = ['inviter_id' => (int)$inviterId, 'referral_id' => (int)$referralId];

            $this->getConnection()->insertOnDuplicate(
                $this->getTable('filoblu_newsletter_invitation_track'),
                $data,
                array_keys($data)
            );
        } catch (\Exception $exception) {
            throw new \Exception("INVITER ERROR: " . $exception->getMessage());
        }
    }
}