<?php

namespace FiloBlu\Referrals\Model;

use FiloBlu\Referrals\Helper\Core;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Registry;
use Magento\Framework\Url\DecoderInterface;
use Magento\Invitation\Model\Invitation;
use Magento\Invitation\Model\Invitation\Status;
use Magento\Invitation\Model\InvitationFactory;

class InvitationProvider extends \Magento\Invitation\Model\InvitationProvider
{
    /**
     * @var Core
     */
    protected $coreHelper;

    /**
     * @param Registry $registry
     * @param InvitationFactory $invitationFactory
     * @param DecoderInterface $urlDecoder
     * @param \FiloBlu\Referrals\Helper\Core $coreHelper
     */
    public function __construct(
        Registry $registry ,
        InvitationFactory $invitationFactory ,
        DecoderInterface $urlDecoder,
        Core $coreHelper
    )
    {
        $this->coreHelper = $coreHelper;
        parent::__construct($registry , $invitationFactory , $urlDecoder);
    }

    /**
     * Retrieve invitation
     *
     * @param RequestInterface $request
     * @return \Magento\Invitation\Model\Invitation
     * @throws \Exception
     */
    public function get(RequestInterface $request)
    {

        if (!$this->coreHelper->isEnabled()) {
            return parent::get($request);
        }

        try {
            if (!$this->registry->registry('current_invitation')) {
                /** @var Invitation $invitation */
                $invitation = $this->invitationFactory->create();
                $invitation->loadByInvitationCode(
                    $this->urlDecoder->decode(
                        $request->getParam('invitation', false)
                    )
                );

                if ($invitation->getStatus() != Status::STATUS_ACCEPTED) {
                    $invitation->makeSureCanBeAccepted();
                }

                $this->registry->register('current_invitation', $invitation);
            }
            return $this->registry->registry('current_invitation');
        } catch (\Exception $e) {
            $this->coreHelper->writeLog("INVITATION ERROR: " . $e->getMessage());
            throw new \Exception($e->getMessage());
        }

    }
}