<?php


namespace FiloBlu\Referrals\Model;


use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use FiloBlu\Referrals\Helper\Core;
use Magento\Framework\App\ObjectManager;
use Magento\Invitation\Model\Invitation\Status;
use Magento\Newsletter\Model\Subscriber;
use Magento\Newsletter\Model\SubscriberFactory;

class Invitation extends \Magento\Invitation\Model\Invitation
{
    const XML_PATH_REFERRAL_EMAIL_TEMPLATE = 'filoblu_referrals/general/templateinvitation';
    /**
     * @var \Magento\Framework\Locale\Resolver
     */
    protected $localeResolver;
    private static $_customerExistsLookup = [];

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Invitation\Helper\Data $invitationData,
        \Magento\Invitation\Model\ResourceModel\Invitation $resource,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Invitation\Model\Config $config,
        \Magento\Invitation\Model\Invitation\HistoryFactory $historyFactory,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Math\Random $mathRandom,
        \Magento\Framework\Stdlib\DateTime $dateTime,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Invitation\Model\Invitation\Status $status,
        \Magento\Framework\Locale\Resolver $localeResolver,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->localeResolver = $localeResolver;
        parent::__construct($context , $registry , $invitationData , $resource , $storeManager , $config , $historyFactory , $customerFactory , $transportBuilder , $mathRandom , $dateTime , $scopeConfig , $status , $resourceCollection , $data);
    }

    /**
     * Send invitation email
     *
     * @return bool
     */
    public function sendInvitationEmail()
    {
        $this->makeSureCanBeSent();
        $store = $this->_storeManager->getStore($this->getStoreId());

        $templateIdentifier = $this->_scopeConfig->getValue(
            self::XML_PATH_REFERRAL_EMAIL_TEMPLATE,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $store
        );
        $from = $this->_scopeConfig->getValue(
            self::XML_PATH_EMAIL_IDENTITY,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $store
        );

        $urls = $this->_invitationData->getInvitationUrl($this);

        $templateVars = [
            'message' => $this->getMessage(),
            'store' => $store,
            'store_name' => $store->getGroup()->getName(),
            'inviter_name' => $this->getInviter() ? $this->getInviter()->getName() : null,
        ];

        foreach ($urls as $name => $url) {
            $templateVars[$name] = $url;
        }

        $this->_transportBuilder->setTemplateIdentifier(
            $templateIdentifier
        )->setTemplateOptions(
            ['area' => \Magento\Framework\App\Area::AREA_FRONTEND, 'store' => $this->getStoreId()]
        )->setTemplateVars(
            $templateVars
        )->setFrom(
            $from
        )->addTo(
            $this->getEmail()
        );
        $transport = $this->_transportBuilder->getTransport();
        try {
            $transport->sendMessage();
        } catch (\Magento\Framework\Exception\MailException $e) {
            $this->getCoreHelper()->writeLog('Unable to send invitation e-mail: ' . $e->getMessage());
            return false;
        }
        $this->setStatus(Status::STATUS_SENT)->setUpdateDate(true)->save();
        return true;
    }

    public function accept($websiteId , $referralId)
    {
        $coreHelper = $this->getCoreHelper();

        $subscriberFactory = $this->getSubscriberFactory();
        $subscriberInfoFactory = $this->getSubscriberInfoFactory();

        $couponInvitationType = $coreHelper->getSysConfigValue($coreHelper::COUPON_FIELD_INVITATION_TYPE);

        $this->makeSureCanBeAccepted($websiteId);

        $this->getResource()->beginTransaction();
        try {
            $this->setReferralId(
                $referralId
            )->setStatus(
                Status::STATUS_ACCEPTED
            )->setSignupDate(
                $this->dateTime->formatDate(time())
            )->save();

            $inviterId = $this->getCustomerId();

            if ($couponInvitationType === 'newsletter') {
                $email = $this->getEmail();
                $subscriber = $subscriberFactory->create()->loadByEmail($email);
                if (!$subscriber->isSubscribed()) {
                    $subscriberFactory->create()->setData('is_referral', true)->setImportMode(true)->subscribe($email);
                    /** @var Subscriber $subscriber */
                    $subscriber = $subscriberFactory->create()->loadByEmail($email);

                    $subscriberInfoSourceType = $coreHelper->getSysConfigValue($coreHelper::NEWSLETTER_SUBSCRIPTION_SOURCE) ?? 'NO';
                    
                    $subscriberInfo = $subscriberInfoFactory->create()->load($subscriber->getSubscriberId());
                    $subscriberInfo
                        ->setSource($subscriberInfoSourceType)
                        ->setWebsiteName($this->_storeManager->getWebsite()->getName())
                        ->setLanguage($this->localeResolver->getLocale());



                    $subscriberInfo->save();
                    
                }
                $this->setData('subscriber_id', $subscriber->getSubscriberId());
            } else {
                $this->assignInvitationDataToCustomer($referralId);
            }


            if ($inviterId) {
                if ($inviterId === $referralId && $this->hasData('subscriber_id')) {
                    $this->getResource()->trackNlSubscriptionReferral($inviterId, $this->getSubscriberId());
                } else {
                    $this->getResource()->trackReferral($inviterId, $referralId);
                }
            }

            $this->getResource()->commit();
        } catch (\Exception $e) {
            $this->getCoreHelper()->writeLog('Error on invitation acceptance: ' . $e->getMessage());
            $this->getResource()->rollBack();
            throw $e;
        }

        return $this;
    }

    /**
     * Check whether this invitation can be accepted
     *
     * @param int|string $websiteId
     * @return void
     * @throws \Magento\Framework\Exception\InputException
     */
    public function makeSureCanBeAccepted($websiteId = null)
    {
        $coreHelper = $this->getCoreHelper();
        $messageInvalid = __('This invitation is not valid.');

        $coreHelper->writeLog("STATUS: " . $this->getStatus());

        if (!$this->getId()) {
            $coreHelper->writeLog("Error in newsletter subscribe: no invitation id");
            throw new \Magento\Framework\Exception\InputException($messageInvalid);
        }
        if (!in_array($this->getStatus(), $this->status->getCanBeAcceptedStatuses())) {
            $coreHelper->writeLog("Error in newsletter subscribe, no status or wrong status: {$this->getStatus()}");
            throw new \Magento\Framework\Exception\InputException($messageInvalid);
        }
        if (null === $websiteId) {
            $websiteId = $this->_storeManager->getWebsite()->getId();
        }
        if ($websiteId != $this->_storeManager->getStore($this->getStoreId())->getWebsiteId()) {
            $coreHelper->writeLog("Error in newsletter subscribe: wrong website id");
            throw new \Magento\Framework\Exception\InputException($messageInvalid);
        }
    }

    /**
     * @return Core|mixed
     */
    public function getCoreHelper() {
        return ObjectManager::getInstance()->get(Core::class);
    }

    /**
     * @return SubscriberFactory|mixed
     */
    public function getSubscriberFactory() {
        return ObjectManager::getInstance()->get(SubscriberFactory::class);

    }

    /**
     * @return SubscriberInfoFactory|mixed
     */
    public function getSubscriberInfoFactory() {
        return ObjectManager::getInstance()->get(SubscriberInfoFactory::class);
    }

    public function makeSureCustomerNotExists($email = null, $websiteId = null)
    {
        if (null === $websiteId) {
            $websiteId = $this->_storeManager->getStore($this->getStoreId())->getWebsiteId();
        }
        if (!$websiteId) {
            throw new \Magento\Framework\Exception\InputException(__("The proper website couldn't be identified"));
        }
        if (null === $email) {
            $email = $this->getEmail();
        }
        if (!$email) {
            throw new \Magento\Framework\Exception\InputException(
                __("An email wasn't specified. Enter the email and try again.")
            );
        }

        $coreHelper = $this->getCoreHelper();

        // lookup customer by specified email/website id
        if (!isset(self::$_customerExistsLookup[$email]) || !isset(self::$_customerExistsLookup[$email][$websiteId])) {
            $customer = $this->_customerFactory->create()->setWebsiteId($websiteId)->loadByEmail($email);
            self::$_customerExistsLookup[$email][$websiteId] = $customer->getId() ? $customer->getId() : false;
        }
        if($coreHelper->getShareLinkType() == "copypaste") {
            self::$_customerExistsLookup[$email][$websiteId] = false;
        }
        if (false === self::$_customerExistsLookup[$email][$websiteId]) {
            return;
        }
        throw new \Magento\Framework\Exception\AlreadyExistsException(
            __('This invitation is addressed to current customer "%1".', $email)
        );
    }
}