<?php

namespace FiloBlu\Referrals\Model\Config\Source;

use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;


class Salesrule implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var \Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory
     */
    protected $collectionFactory;

    public function __construct(
        CollectionFactory $collectionFactory
    )
    {
        $this->collectionFactory = $collectionFactory;
    }

    public function toOptionArray()
    {
        $rules = $this->collectionFactory->create()->addIsActiveFilter();
        foreach ($rules as $rule) {
            $options[] = ['value' => $rule->getRuleId(), 'label' => $rule->getName()];
        }
        $sorted_options = usort($options, array($this, "compare"));
        $prepend_element = ['value' => '', 'label' => 'Select rule'];
        array_unshift($options, $prepend_element);

        return $options;
    }

    public function compare($a, $b) {
        return strcasecmp($a['label'], $b['label']);
    }
}