<?php

namespace FiloBlu\Referrals\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory;

/**
 *
 */
class Orderstatus implements  OptionSourceInterface
{
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory $statusCollectionFactory
     */
    protected $statusCollectionFactory;

    /**
     * @param \Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory $statusCollectionFactory
     */
    public function __construct(
        CollectionFactory $statusCollectionFactory
    )
    {
        $this->statusCollectionFactory = $statusCollectionFactory;
    }

    public function toOptionArray()
    {

        $options = $this->statusCollectionFactory->create()->toOptionArray();
        $prepend_element = ['value' => 'any', 'label' => 'Any status'];
        array_unshift($options, $prepend_element);

        return $options;
    }
}