<?php


namespace FiloBlu\Referrals\Helper;


use Magento\Invitation\Model\Invitation;

class Data extends \Magento\Invitation\Helper\Data
{
    /**
     * @var Core
     */
    protected $helper;

    /**
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Customer\Model\Registration $registration
     * @param \Magento\Invitation\Model\Source\Invitation\Status $invitationStatus
     * @param \FiloBlu\Referrals\Helper\Core $helper
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context ,
        \Magento\Customer\Model\Registration $registration ,
        \Magento\Invitation\Model\Source\Invitation\Status $invitationStatus,
        \FiloBlu\Referrals\Helper\Core $helper
    )
    {
        /** @var \FiloBlu\Referrals\Helper\Core helper */
        $this->helper = $helper;
        parent ::__construct($context , $registration , $invitationStatus);
    }

    /**
     * Return invitation url
     *
     * @param Invitation $invitation
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getInvitationUrl($invitation)
    {

        $couponInvitationType = $this->helper->getSysConfigValue($this->helper::COUPON_FIELD_INVITATION_TYPE);

        $url = [
            'siteRegistration_url' => '',
            'newsletter_url' => ''
        ];

        switch ($couponInvitationType) {
            case 'site':
                $url['siteRegistration_url'] = $this->_urlBuilder->setScope(
                    $invitation->getStoreId()
                )->getUrl(
                    'magento_invitation/customer_account/create',
                    [
                        'invitation' => $this->urlEncoder->encode($invitation->getInvitationCode()),
                        '_scope_to_url' => true,
                        '_nosid' => true
                    ]
                );
                break;
            case 'newsletter':
                $url['newsletter_url'] = $this->_urlBuilder->setScope(
                    $invitation->getStoreId()
                )->getUrl(
                    'filoblu_referrals/subscriber/subscribe',
                    [
                        'invitation' => $this->urlEncoder->encode($invitation->getInvitationCode()),
                        '_scope_to_url' => true,
                        '_nosid' => true
                    ]
                );
                break;
            default:

                $url['siteRegistration_url'] = $this->_urlBuilder->setScope(
                    $invitation->getStoreId()
                )->getUrl(
                    'magento_invitation/customer_account/create',
                    [
                        'invitation' => $this->urlEncoder->encode($invitation->getInvitationCode()),
                        '_scope_to_url' => true,
                        '_nosid' => true
                    ]
                );

                $url['newsletter_url'] = $this->_urlBuilder->setScope(
                    $invitation->getStoreId()
                )->getUrl(
                    'filoblu_referrals/subscriber_account/create',
                    [
                        'invitation' => $this->urlEncoder->encode($invitation->getInvitationCode()),
                        '_scope_to_url' => true,
                        '_nosid' => true
                    ]
                );

                break;
        }

        return $url;
    }
}