<?php


namespace FiloBlu\Referrals\Helper;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\ResourceConnection;
use Magento\Invitation\Model\ResourceModel\Invitation\CollectionFactory;
use Magento\SalesRule\Model\Coupon\MassgeneratorFactory;
use Magento\SalesRule\Model\CouponFactory;
use Magento\SalesRule\Model\ResourceModel\Coupon;
use Magento\SalesRule\Model\ResourceModel\Rule;
use Magento\SalesRule\Model\RuleFactory;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory as OrderCollection;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Customer\Model\Session;
use Magento\Framework\Encryption\EncryptorInterface;



class Core extends AbstractHelper
{

    // Do not change this
    const INVITATION_COUPON_PREFIX = 'INV-';

    const COUPON_FIELD_INVITATION_TYPE = 'filoblu_referrals/general/referral_invitation_type';
    const COUPON_FIELD_NEWSLETTER_SUBSCRIPTION_REDIRECT = 'filoblu_referrals/general/newsletter_subscription_redirect';
    const COUPON_FIELD_NAME_FOR_WHO_SEND_THE_INVITE = 'coupon_for_who_sent_the_invite';
    const COUPON_FIELD_NAME_FOR_WHO_GET_INVITED = 'coupon_for_who_got_invited';
    const NEWSLETTER_SUBSCRIPTION_SOURCE = 'filoblu_referrals/general/newsletter_subscription_source';
    const REF_DISABLE_SUBSCRIBER_WELCOME_MAIL = 'filoblu_referrals/general/subscriber_welcome_email_enabled';
    const COUPON_FIELD_SENDER_RULE_ID = 'filoblu_referrals/general/ruleidsender';
    const COUPON_FIELD_RECEIVER_RULE_ID = 'filoblu_referrals/general/ruleidreceiver';
    const SHARE_LINK_TYPE = 'filoblu_referrals/general/referral_sharelink_type';

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    private $_customerRepositoryInterface;
    protected $ruleFactory;
    protected $massGeneratorFactory;
    protected $couponFactory;
    protected $coupon;
    protected $ruleResource;
    protected $invitationCollectionFactory;
    protected $orderFactory;

    protected $_resource;
    protected $connection;
    protected $customerSession;
    protected $encryptor;

    /**
     * @param Context $context
     */
    public function __construct(
        Context $context,
        CustomerRepositoryInterface $customerRepositoryInterface,
        Rule $rulesResource,
        MassgeneratorFactory $massgeneratorFactory,
        CouponFactory $couponFactory,
        Coupon $coupon,
        RuleFactory $ruleFactory,
        CollectionFactory $invitationCollectionFactory,
        ResourceConnection $resource,
        OrderCollection $orderFactory,
        StoreManagerInterface $storeManager,
        Session $customerSession,
        EncryptorInterface $encryptor
    ) {
        parent::__construct($context);
        $this->_customerRepositoryInterface = $customerRepositoryInterface;
        $this->ruleResource = $rulesResource;
        $this->massGeneratorFactory = $massgeneratorFactory;
        $this->couponFactory = $couponFactory;
        $this->coupon = $coupon;
        $this->ruleFactory = $ruleFactory;
        $this->invitationCollectionFactory = $invitationCollectionFactory;
        $this->_resource = $resource;
        $this->orderFactory = $orderFactory;
        $this->storeManager = $storeManager;
        $this->customerSession = $customerSession;
        $this->encryptor = $encryptor;
    }

    /**
     * @return bool
     */
    public function isEnabled($storeId = null)
    {
        return $this->scopeConfig->getValue('filoblu_referrals/general/enabled', ScopeInterface::SCOPE_STORES, $storeId);
    }

    protected function getConnection()
    {
        if (!$this->connection) {
            $this->connection = $this->_resource->getConnection('core_read');
        }
        return $this->connection;
    }

    /**
     * Simple function to write logs.
     * Zero hassle. Works always.
     */
    public function writeLog($message, $log_name = 'referrals.log'){
        $writer = new \Zend_Log_Writer_Stream(BP . "/var/log/{$log_name}");
        $logger = new \Zend_Log();
        $logger->addWriter($writer);
        $logger->info($message);

    }

    public function generateCoupon($couponCodeId, $expireDate = false)
    {
        if ($couponCodeId) {
            $rule = $this->ruleFactory->create();
            $this->ruleResource->load($rule, $couponCodeId);

            $generator = $this->massGeneratorFactory->create();
            $generator->setFormat(
                \Magento\SalesRule\Helper\Coupon::COUPON_FORMAT_ALPHANUMERIC
            );
            $generator->setRuleId($couponCodeId);
            $generator->setUsesPerCoupon(1);
            $generator->setDash(0);
            $generator->setLength(9);
            $generator->setPrefix(self::INVITATION_COUPON_PREFIX);
            $generator->setSuffix('');

            //set the generation settings
            $rule->setCouponCodeGenerator($generator);
            $rule->setCouponType(
                \Magento\SalesRule\Model\Rule::COUPON_TYPE_AUTO
            );

            //generate the coupon
            $coupon = $rule->acquireCoupon();
            $couponCode = $coupon->getCode();

            //save the type of coupon
            /** @var \Magento\SalesRule\Model\Coupon $couponModel */
            $couponModel = $this->couponFactory->create()
                ->loadByCode($couponCode);
            $couponModel->setType(
                \Magento\SalesRule\Model\Rule::COUPON_TYPE_NO_COUPON
            )->setGeneratedByInvitationReferral(1);

            if ($expireDate) {
                $couponModel->setExpirationDate($expireDate);
            } elseif ($rule->getToDate()) {
                $couponModel->setExpirationDate($rule->getToDate());
            }

            $this->coupon->save($couponModel);

            return $couponCode;
        }

        return false;
    }

    public function getInvitationByDbField($field,$value,$return_first = true){
        $collection = $this->invitationCollectionFactory->create();
        $collection->addFieldToSelect('*');
        $collection->addFieldToFilter($field,$value);

        if ($collection->getSize() > 0){
            if($return_first) {
                $invitation = $collection->getFirstItem();
            }
            else {
                $invitation = $collection;
            }

            return $invitation;
        }

        return false;
    }

    public function getInvitationByCouponCode($couponCode){
        $collection = $this->invitationCollectionFactory->create();
        $collection->addFieldToSelect('*');
        $collection->addFieldToFilter(
            [
                $this->getCouponDbFieldNameForWhoGotInvited(),
                $this->getCouponDbFieldNameForWhoSentTheInvite()
            ],
            [
                ['eq' =>$couponCode],
                ['eq' =>$couponCode]
            ]
        );

        if ($collection->getSize() > 0){
            return $collection->getFirstItem();
        }

        return false;
    }

    public function getOrderByEmail($email) {
        if(!$email || $email == '') {
            return false;
        }

        $order_collection = $this->orderFactory->create();
        $order_collection->addFieldToSelect('*');
        $order_collection->addFieldToFilter('customer_email',$email);
        if($order_collection->getSize() > 0) {
            return $order_collection;
        }

        return false;
    }

    public function getCustomerById($id){
        return $this->_customerRepositoryInterface->getById($id);
    }

    public function getCustomerByEmail($email){
        return $this->_customerRepositoryInterface->get($email);
    }

    public function whoInvitedCustomerId($id = 0, $isNewsletter = false){
        $query = "SELECT * FROM magento_invitation_track WHERE referral_id = '{$id}'";

        if ($isNewsletter) {
            $query = "SELECT * FROM filoblu_newsletter_invitation_track WHERE referral_id = '{$id}'";
        }

        $row = $this->getConnection()->fetchRow($query);

        if(isset($row['inviter_id']) && $row['inviter_id']){
            return $row['inviter_id'];
        }

        return false;
    }

    public function isInvitationalTypeCoupon($coupon_code=null){
        if (!$coupon_code){
            return false;
        }
        $prefix = $result = substr($coupon_code, 0, 4);
        if ($prefix == self::INVITATION_COUPON_PREFIX){
            return true;
        }
        return false;
    }

    public function getCouponDbFieldNameForWhoSentTheInvite(){
        return self::COUPON_FIELD_NAME_FOR_WHO_SEND_THE_INVITE;
    }

    public function getCouponDbFieldNameForWhoGotInvited(){
        return self::COUPON_FIELD_NAME_FOR_WHO_GET_INVITED;
    }

    public function getSysConfigValue($path,$scope_type=null,$scope_value=null){
        if($scope_type && $scope_value){
            $result = $this->scopeConfig->getValue($path,$scope_type,$scope_value);
        } else {
            $result = $this->scopeConfig->getValue($path);
        }
        return $result;
    }

    public function isReferral($referralId)
    {
        $query = "SELECT * FROM filoblu_newsletter_invitation_track WHERE referral_id = '{$referralId}'";

        $row = $this->getConnection()->fetchRow($query);

        if(!isset($row['track_id']) || !$row['track_id']){
            return false;
        }

        return true;
    }

    public function isSubscriberWelcomeEmailEnabled() {
        return $this->scopeConfig->getValue(self::REF_DISABLE_SUBSCRIBER_WELCOME_MAIL);
    }

    public function getReceiverRuleId() {
        return $this->getSysConfigValue(self::COUPON_FIELD_RECEIVER_RULE_ID);
    }

    public function getSenderRuleId() {
        return $this->getSysConfigValue(self::COUPON_FIELD_SENDER_RULE_ID);
    }

    public function getCuponInfo($cuopnCode) {
        return $this->couponFactory->create()->loadByCode($cuopnCode);
    }

    public function getShareLinkType() {
        return $this->scopeConfig->getValue(self::SHARE_LINK_TYPE);
    }

    public function generateReferralCode($customer) {
        $referral_code = '';
        if($customer->getId()) {
            $customer_id = $customer->getId();
            $customer_firstname = $customer->getFirstname();
            $customer_lastname = $customer->getLastname();
            $code_from_customer = $customer_firstname.$customer_lastname.'-'.$customer_id;
            $referral_code = str_replace(" ", "", $code_from_customer);
        }

        return $referral_code;
    }

    public function generateUrlReferral() {

        if(!$this->customerSession->isLoggedIn()) {
            return '';
        }

        $customerData = $this->customerSession->getCustomerData();
        $referral_code = $this->generateReferralCode($customerData);
        $couponInvitationType = $this->getSysConfigValue(self::COUPON_FIELD_INVITATION_TYPE);

        switch ($couponInvitationType) {
            case 'site':
                $base_referral_url = 'magento_invitation/customer_account/create';
                break;
            case 'newsletter':
                $base_referral_url = 'filoblu_referrals/subscriber/subscribe';
                break;
            default:
                $base_referral_url = 'magento_invitation/customer_account/create';
        }

        return $this->_urlBuilder
            ->setScope($customerData->getStoreId())
            ->getUrl($base_referral_url, [
                'invitation' => $this->urlEncoder->encode($referral_code),
                '_scope_to_url' => true,
                '_nosid' => true
            ]);
    }

    public function getCustomerByInvitationCode($invitationCode) {
        $clear_code = base64_decode($invitationCode);
        $code_data = explode('-', $clear_code);
        $customerId = $code_data[1];

        return $this->_customerRepositoryInterface->getById($customerId);
    }
}
