<?php

namespace FiloBlu\Referrals\Cron;

use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;

use function count;

/**
 *
 */
class Sendercoupon
{
    const ORDER_STATUSES_TO_BE_MONITORED = 'filoblu_referrals/general/referral_order_statuses_to_monitor';
    const WHEN_SEND_COUPON_TO_SENDER = 'filoblu_referrals/general/when_send_coupon_to_sender';
    const DAYS_AFTER_ORDER = 'filoblu_referrals/general/number_days_after_order';

    /**
     * @var \FiloBlu\Referrals\Helper\Core
     */
    protected $_referralHelper;

    /**
     * @var \FiloBlu\Referrals\Helper\Email
     */
    protected $_emailHelper;

    /**
     * @var SubscriberFactory
     */
    protected $subscriberFactory;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $orderFactory;

    public function __construct(
        \FiloBlu\Referrals\Helper\Core $referralHelper,
        \FiloBlu\Referrals\Helper\Email $emailHelper,
        SubscriberFactory $subscriberFactory,
        CollectionFactory $orderFactory
    ) {
        $this->_referralHelper = $referralHelper;
        $this->_emailHelper = $emailHelper;
        $this->subscriberFactory = $subscriberFactory;
        $this->orderFactory = $orderFactory;
    }


    public function execute()
    {
        $this->_referralHelper->writeLog('START cron send coupon to the sender');
        if (!$this->_referralHelper->isEnabled()) {
            return $this;
        }

        $when_send_coupon_to_sender = $this->_referralHelper->getSysConfigValue(self::WHEN_SEND_COUPON_TO_SENDER);
        $this->_referralHelper->writeLog("config when send coupon: '$when_send_coupon_to_sender'");

        if ($when_send_coupon_to_sender !== 'days_after_order_receiver') {
            return $this;
        }

        $invitations = $this->_referralHelper->getInvitationByDbField('who_sent_the_invite_cp_sent', '0', false);
        $this->_referralHelper->writeLog('found ' . count($invitations) . ' invitations');
        if ($invitations) {
            foreach ($invitations as $invitation) {
                $this->_referralHelper->writeLog("Invitation ID {$invitation->getInvitationId()}");
                $this->_referralHelper->writeLog("Invitation status {$invitation->getStatus()}");

                if ($invitation->getStatus() !== 'accepted') {
                    continue;
                }

                if ($invitation->getWhoGotInvitedCpSent() == '0' || $invitation->getWhoSentTheInviteCpSent() == '1') {
                    continue;
                }

                $referral_customer_data = $this->_referralHelper->getCustomerById($invitation->getReferralId());
                $this->_referralHelper->writeLog("Referral customer ID: {$referral_customer_data->getId()}" );
                if (!$referral_customer_data->getId()) {
                    continue;
                }

                $referral_email = $invitation->getEmail();
                $referral_coupon = $invitation->getCouponForWhoGotInvited();

                $order_collection = $this->_referralHelper->getOrderByEmail($referral_email);
                if ($order_collection) {
                    $days_after_order = $this->_referralHelper->getSysConfigValue(self::DAYS_AFTER_ORDER);
                    $orderDate = date('Y-m-d', strtotime('-' . $days_after_order . ' days'));
                    $order_collection->addAttributeToFilter('created_at', ['lteq' => $orderDate . ' 23:59:59']);

                    $allowed_order_statuses_to_be_monitored = $this->_referralHelper->getSysConfigValue(
                        self::ORDER_STATUSES_TO_BE_MONITORED
                    );
                    if ($allowed_order_statuses_to_be_monitored && $allowed_order_statuses_to_be_monitored != 'any') {
                        $allowed_order_statuses_to_be_monitored = explode(',', $allowed_order_statuses_to_be_monitored);
                        if (count($allowed_order_statuses_to_be_monitored) > 0) {
                            $order_collection->addAttributeToFilter(
                                'status',
                                ['in' => $allowed_order_statuses_to_be_monitored]
                            );
                        }
                    }

                    if (count($order_collection->getItems()) > 0) {
                        foreach ($order_collection as $order) {
                            $result = $this->_emailHelper->notify_invitation_sender($invitation);
                            $this->_referralHelper->writeLog(
                                "COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | Sending coupon to the sender of invitation_id {$invitation->getInvitationId()}"
                            );
                            if ($result) {
                                $this->_referralHelper->writeLog(
                                    "COUPON ORDER COMPLETE: increment_id {$order->getIncrementId()} | Sended coupon!"
                                );
                                $invitation->setWhoSentTheInviteCpSent(1);
                                $invitation->save();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return $this;
    }


}
