<?php

namespace FiloBlu\Referrals\Controller\Subscriber;

use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Invitation\Model\InvitationProvider;
use FiloBlu\Referrals\Helper\Core;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Invitation\Model\Invitation\Status;


class Subscribe extends \Magento\Framework\App\Action\Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var InvitationProvider
     */
    protected $invitationProvider;

    /**
     * @var \FiloBlu\Referrals\Helper\Core
     */
    protected $coreHelper;

    /**
     * @var SubscriberFactory
     */
    protected $subscriberFactory;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Customer session
     *
     * @var Session
     */
    protected $customerSession;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        InvitationProvider $invitationProvider,
        Core $coreHelper,
        SubscriberFactory $subscriberFactory,
        StoreManagerInterface $storeManager,
        Session $customerSession
    )
    {
        parent ::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->invitationProvider = $invitationProvider;
        $this->coreHelper = $coreHelper;
        $this->subscriberFactory = $subscriberFactory;
        $this->storeManager = $storeManager;
        $this->customerSession = $customerSession;
    }

    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        $newsletterSubscriprionRedirect = $this->coreHelper->getSysConfigValue($this->coreHelper::COUPON_FIELD_NEWSLETTER_SUBSCRIPTION_REDIRECT) ?? 'home';
        $resultRedirect->setPath($newsletterSubscriprionRedirect);

        try {
            $invitation = $this->invitationProvider->get($this->getRequest());

            if ($invitation->getStatus() == Status::STATUS_ACCEPTED) {
                $this->messageManager->addSuccessMessage(__('You have already accepted this invitation!'));

                return $resultRedirect;
            }

            $customerId = $this->customerSession->getCustomerId();

            /**
             * TODO: cast customer id quando si usa la newsletter
             */
            if (!$customerId) {

                $couponInvitationType = $this->coreHelper->getSysConfigValue($this->coreHelper::COUPON_FIELD_INVITATION_TYPE);
                if ($couponInvitationType !== 'site') {
                    $customerId = $invitation->getCustomerId();
                }
            }

            $invitation->accept($this->storeManager->getWebsite()->getId(), $customerId);


        } catch (\Exception $e) {
            $this->coreHelper->writeLog("Error in newsletter subscribe: " . $e->getMessage());
            //$this->_customerSession->setCustomerFormData($this->getRequest()->getPostValue());
            $this->messageManager->addException($e, __('We can\'t save this customer.'));

            return $resultRedirect;
        }

        $this->messageManager->addSuccessMessage(__('You have successfully subscribed to our newsletter!'));

        return $resultRedirect;
    }
}