<?php

namespace FiloBlu\Referrals\Controller\Customer\Account;

use Exception;
use FiloBlu\Referrals\Helper\Core;
use Magento\Customer\Api\Data\AddressInterfaceFactory;
use Magento\Customer\Api\Data\CustomerInterfaceFactory;
use Magento\Customer\Api\Data\RegionInterfaceFactory;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\LocalizedException as FrameworkException;
use Magento\Invitation\Model\InvitationFactory;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory;
use Magento\Store\Model\ScopeInterface;

use function count;

/**
 * Post create customer action
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class CreatePost extends \Magento\Invitation\Controller\Customer\Account\CreatePost
{
    /** @var string */
    public const RULE_ID_SENDER_OF_THE_INVITE = 'filoblu_referrals/general/ruleidsender';
    /** @var string */
    public const RULE_ID_RECEIVER_OF_THE_INVITE = 'filoblu_referrals/general/ruleidreceiver';
    /**
     * @var \FiloBlu\Referrals\Helper\Core
     */
    protected $coreHelper;
    /**
     * @var  \Magento\Invitation\Model\InvitationFactory
     */
    protected $invitationFactory;
    /**
     * @var \Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory
     */
    protected $ruleCollectionFactory;

    /**
     * Create customer account action
     *
     * @return \Magento\Framework\Controller\Result\Redirect
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();

        try {
            if ($this->getCoreHelper()->getShareLinkType() !== 'copypaste') {
                $invitation = $this->invitationProvider->get($this->getRequest());
            }

            \Magento\Customer\Controller\Account\CreatePost::execute();

            if ($this->getCoreHelper()->getShareLinkType() === 'copypaste') {
                $invitationCode = $this->getRequest()->getParam('invitation');
                $referralCustomer = $this->getCoreHelper()->getCustomerByInvitationCode($invitationCode);
                $invitation = $this->getInvitationFactory()->create();
                $invitation->setData(
                    [
                        'email'    => $this->getRequest()->getParam('email'),
                        'customer' => $referralCustomer,
                        'message'  => ''
                    ]
                )->save();

                $invitationCoupon = $this->getInvitationCoupons();
                if (count($invitationCoupon) > 0) {
                    foreach ($invitationCoupon as $couponField => $couponCode) {
                        $invitation->setData($couponField, $couponCode);
                    }
                    $invitation->save();
                }

                $invitation->accept($this->storeManager->getWebsite()->getId(), $this->session->getCustomer()->getId());
            }
            /*else {
                //$invitation = $this->getInvitationFactory()->create();
                $customerId = $this->session->getCustomerId();
                if ($customerId) {
                    $invitation->accept($this->storeManager->getWebsite()->getId(), $customerId);
                }
            }*/

            $resultRedirect->setPath('customer/account/');
            return $resultRedirect;
        } catch (AlreadyExistsException $e) {
            $this->messageManager->addError($e->getMessage());
            $this->session->setCustomerFormData($this->getRequest()->getPostValue());
        } catch (InputException $e) {
            $this->messageManager->addError($e->getMessage());
            $this->session->setCustomerFormData($this->getRequest()->getPostValue());
        } catch (FrameworkException $e) {
            if ($this->registration->isAllowed()) {
                $this->messageManager->addErrorMessage(__('Your invitation is not valid. Please create an account.'));
                $resultRedirect->setPath('customer/account/create');
                return $resultRedirect;
            }

            $this->messageManager->addErrorMessage(
                __(
                    'Your invitation is not valid. Please contact us at %1.',
                    $this->scopeConfig->getValue(
                        'trans_email/ident_support/email',
                        ScopeInterface::SCOPE_STORE
                    )
                )
            );
            $resultRedirect->setPath('customer/account/login');
            return $resultRedirect;
        } catch (Exception $e) {
            $this->session->setCustomerFormData($this->getRequest()->getPostValue());
            $this->messageManager->addException($e, __('We can\'t save this customer.'));
        }

        $resultRedirect->setPath('magento_invitation/customer_account/create', ['_current' => true, '_secure' => true]);
        return $resultRedirect;
    }

    /**
     * @return \FiloBlu\Referrals\Helper\Core
     */
    public function getCoreHelper(): Core
    {
        if ($this->coreHelper) {
            return $this->coreHelper;
        }

        $this->coreHelper = ObjectManager::getInstance()->get(Core::class);
        return $this->coreHelper;
    }

    /**
     * @return \Magento\Invitation\Model\InvitationFactory
     */
    public function getInvitationFactory(): InvitationFactory
    {
        if ($this->invitationFactory) {
            return $this->invitationFactory;
        }

        $this->invitationFactory = ObjectManager::getInstance()->get(InvitationFactory::class);
        return $this->invitationFactory;
    }

    /**
     * @return array
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    private function getInvitationCoupons()
    {
        $invitationCoupons = [];
        $sender_db_field = $this->getCoreHelper()->getCouponDbFieldNameForWhoSentTheInvite();
        $receiver_db_field = $this->getCoreHelper()->getCouponDbFieldNameForWhoGotInvited();

        $this->getCoreHelper()->writeLog('Preparing the coupons!');

        // Generating and saving the coupon code (magento_invitation table) for the user that send the invite
        $rule_id = $this->getCoreHelper()->getSysConfigValue(
            self::RULE_ID_SENDER_OF_THE_INVITE,
            'store',
            $this->storeManager->getStore()->getId()
        );
        $rule_loaded = $this->loadSalesRuleById($rule_id);
        if ($rule_loaded && $rule_loaded->getRuleId()) {
            $coupon_code_generated = $this->getCoreHelper()->generateCoupon($rule_loaded->getRuleId());
            if ($coupon_code_generated) {
                $invitationCoupons[$sender_db_field] = $coupon_code_generated;
                $this->getCoreHelper()->writeLog(
                    "Success: generated the coupon {$coupon_code_generated} for " . $sender_db_field
                );
            } else {
                $this->getCoreHelper()->writeLog("Error: Coupon for '$sender_db_field' NOT generated!");
            }
        } else {
            $this->getCoreHelper()->writeLog("Error: Salesrule ID '$rule_id' NOT found!");
        }

        // Generating and saving the coupon code (magento_invitation table) for the user that is invited
        $rule_id = $this->getCoreHelper()->getSysConfigValue(
            self::RULE_ID_RECEIVER_OF_THE_INVITE,
            'store',
            $this->storeManager->getStore()->getId()
        );
        $rule_loaded = $this->loadSalesRuleById($rule_id);
        if ($rule_loaded && $rule_loaded->getRuleId()) {
            $coupon_code_generated = $this->getCoreHelper()->generateCoupon($rule_loaded->getRuleId());
            if ($coupon_code_generated) {
                $invitationCoupons[$receiver_db_field] = $coupon_code_generated;
                $this->getCoreHelper()->writeLog(
                    "Success: generated the coupon {$coupon_code_generated} for $receiver_db_field"
                );
            } else {
                $this->getCoreHelper()->writeLog("Error: Coupon for $receiver_db_field NOT generated!");
            }
        } else {
            $this->getCoreHelper()->writeLog("Error: Salesrule ID $rule_id NOT found!");
        }

        return $invitationCoupons;
    }

    /**
     * @param $id
     * @return false
     */
    protected function loadSalesRuleById($id = null)
    {
        if (!$id || !is_numeric($id)) {
            return false;
        }

        $collection = $this->getRuleCollectionFactory()->create();
        $collection->addFieldToSelect('*');
        $collection->addFieldToFilter('rule_id', $id);

        if ($collection->getSize()) {
            return $collection->getFirstItem();
        }

        return false;
    }

    /**
     * @return \Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory
     */
    public function getRuleCollectionFactory(): CollectionFactory
    {
        if ($this->ruleCollectionFactory) {
            return $this->ruleCollectionFactory;
        }

        $this->ruleCollectionFactory = ObjectManager::getInstance()->get(CollectionFactory ::class);
        return $this->ruleCollectionFactory;
    }
}
