<?php

declare(strict_types=1);
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace FiloBlu\Referrals\Controller\Customer\Account;

use Magento\Customer\Model\Registration;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Result\PageFactory;
use Magento\Invitation\Controller\Customer\AccountInterface;
use Magento\Invitation\Model\InvitationProvider;
use Magento\Framework\Controller\ResultFactory;
use FiloBlu\Referrals\Helper\Core;

class Create extends \Magento\Invitation\Controller\Customer\Account\Create
{
    protected $coreHelper;

    /**
     * @param Context $context
     * @param Session $customerSession
     * @param PageFactory $resultPageFactory
     * @param Registration $registration
     * @param InvitationProvider $invitationProvider
     * @param \FiloBlu\Referrals\Helper\Core $coreHelper
     */
    public function __construct(
        Context $context,
        Session $customerSession,
        PageFactory $resultPageFactory,
        Registration $registration,
        InvitationProvider $invitationProvider,
        Core $coreHelper
    ) {
        $this->coreHelper = $coreHelper;
        parent::__construct(
            $context,
            $customerSession,
            $resultPageFactory,
            $registration,
            $invitationProvider
        );
        
    }

    /**
     * Customer register form page
     *
     * @return \Magento\Framework\Controller\Result\Redirect|\Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        try {
            if($this->coreHelper->getShareLinkType() !== 'copypaste') {
                $this->invitationProvider->get($this->getRequest());
            }
                
            return $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        } catch (LocalizedException $e) {
            $this->messageManager->addError($e->getMessage());
        }

        /** @var \Magento\Framework\Controller\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('customer/account/login');
    }
}
