<?php

namespace FiloBlu\Referrals\Block\Adminhtml\Invitation\Grid\Column;

use Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer;

/**
 *
 */
class Inviter extends AbstractRenderer
{

    protected $_url;
    protected $customerRepository;

    public function __construct(
        \Magento\Backend\Block\Context $context,
        \Magento\Backend\Model\UrlInterface $url,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_url = $url;
        $this->customerRepository = $customerRepository;
    }


    protected function _getValue(\Magento\Framework\DataObject $row)
    {
        if ($row->getCustomerId()) {
            $customer = $this->customerRepository->getById($row->getCustomerId());
            if ($customer->getEmail()) {
                return $customer->getEmail();
            }
        }
        return "";
    }
}
