<?php
/**
 * Created by PhpStorm.
 * User: raffaele
 * Date: 14/12/17
 * Time: 12.55
 */

namespace FiloBlu\Paymentscapture\Model;

class Usage extends \Magento\SalesRule\Model\ResourceModel\Coupon\Usage {

    public function reduceCouponTimesUsed($customerId, $couponId)
    {
        $connection = $this->getConnection();
        $select = $connection->select();
        $select->from(
            $this->getMainTable(),
            ['times_used']
        )->where(
            'coupon_id = :coupon_id'
        )->where(
            'customer_id = :customer_id'
        );

        $timesUsed = $connection->fetchOne($select, [':coupon_id' => $couponId, ':customer_id' => $customerId]);

        if ($timesUsed > 1) {
            $this->getConnection()->update(
                $this->getMainTable(),
                ['times_used' => $timesUsed - 1],
                ['coupon_id = ?' => $couponId, 'customer_id = ?' => $customerId]
            );
        } elseif ($timesUsed == 1) {
            $this->getConnection()->delete(
                $this->getMainTable(),
                ['coupon_id = ?' => $couponId, 'customer_id = ?' => $customerId]
            );
        }
    }
}