<?php
/**
 * @category FiloBlu_Paymentfraud
 * @subpackage FiloBlu_Paymentfraud_Helper
 * @copyright (c) 2014, FiloBlu
 * @author Mattia Zoccarato <mattia@filoblu.com>
 */
namespace FiloBlu\Paymentscapture\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper {

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Payment\Transaction\CollectionFactory
     */
    protected $salesResourceModelOrderPaymentTransactionCollectionFactory;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Sales\Model\ResourceModel\Order\Payment\Transaction\CollectionFactory $salesResourceModelOrderPaymentTransactionCollectionFactory
    ) {
        $this->salesResourceModelOrderPaymentTransactionCollectionFactory = $salesResourceModelOrderPaymentTransactionCollectionFactory;
        parent::__construct(
            $context
        );
    }

        
    /**
     * 
     * @param \Magento\Sales\Model\Order $order
     * @return boolean
     */
    public function isOrderVoided(\Magento\Sales\Model\Order $order){
        
        $transactions = $this->salesResourceModelOrderPaymentTransactionCollectionFactory->create();
        $transactions->addOrderIdFilter($order->getId());
        $transactions->addTxnTypeFilter('void');
        $transactions->addOrderInformation(array('increment_id'));
        $transactions->addPaymentInformation(array('method'));
        $transactions->load();
        return (bool)$transactions->count();
    }
    
}
