<?php

namespace FiloBlu\Paymentscapture\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Logger\Handler\Base;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Store\Model\ScopeInterface;
use Monolog\Logger;

class CustomLogger
{
    const CAPTURE_DEBUG_CONFIG_PATH = 'filoblu_paymentscapture/general/debug';
    const CLEANING_DEBUG_CONFIG_PATH = 'filoblu_paymentscapture/order_clean/debug';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var Base
     */
    private $paymentsCaptureLogger;
    /**
     * @var Base
     */
    private $orderCleanLogger;
    /**
     * @var SerializerInterface
     */
    private $serializer;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Base                 $paymentsCaptureLogger,
        Base                 $orderCleanLogger,
        SerializerInterface  $serializer
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->paymentsCaptureLogger = $paymentsCaptureLogger;
        $this->orderCleanLogger = $orderCleanLogger;
        $this->serializer = $serializer;
    }

    /**
     * @param null|int|string $storeId
     * @return bool
     */
    public function paymentsCaptureLogIsEnabled($storeId = null)
    {
        return $this->scopeConfig->isSetFlag(self::CAPTURE_DEBUG_CONFIG_PATH, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param null|int|string $storeId
     * @return bool
     */
    public function orderCleanLogIsEnabled($storeId = null)
    {
        return $this->scopeConfig->isSetFlag(self::CLEANING_DEBUG_CONFIG_PATH, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param array|string $data
     * @return array
     */
    protected function enrichData($data)
    {
        if (is_array($data)) {
            $data = $this->serializer->serialize($data);
        }
        return [
            'message' => $data,
            'datetime' => new \DateTime(),
            'channel' => 'filoblu_payments_capture',
            'level_name' => 'DEBUG',
            'level' => Logger::DEBUG,
            'context' => [],
            'extra' => []
        ];
    }

    /**
     * @param array|string $data
     * @param null|int|string $storeId
     */
    public function paymentsCaptureLog($data, $storeId = null)
    {
        if ($this->paymentsCaptureLogIsEnabled($storeId)) {
            $this->paymentsCaptureLogger->handle($this->enrichData($data));
        }
    }

    /**
     * @param array|string $data
     * @param null|int|string $storeId
     */
    public function orderCleanLog($data, $storeId = null)
    {
        if ($this->orderCleanLogIsEnabled($storeId)) {
            $this->orderCleanLogger->handle($this->enrichData($data));
        }
    }
}
