<?php

namespace FiloBlu\Paymentscapture\Console;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CleanCommand extends Command
{
    /**
     * @var \FiloBlu\Paymentscapture\Model\OrdercleanFactory
     */
    private $cleaner;
    
    /**
     *
     * @var \Magento\Framework\App\State 
     */
    private $state;

    /**
     * CleanCommand constructor.
     * @param \FiloBlu\Paymentscapture\Model\OrdercleanFactory $cleaner
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(\FiloBlu\Paymentscapture\Model\OrdercleanFactory $cleaner, \Magento\Framework\App\State $state)
    {
        $this->cleaner = $cleaner;
        $this->state = $state;
        parent::__construct();
    }
 
    protected function configure()
    {
        $this->setName('filoblu:paymentscapture:clean')->setDescription('Clean stalled orders based on configuration parameters');
    }
 
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);
        } catch (\Exception $e) {
            //noop: area code already set
        }
        $this->cleaner->create()->cleanOrders();
    }
 
}