<?php

namespace FiloBlu\Paymentscapture\Console;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CaptureCommand extends Command
{
    /**
     * @var \FiloBlu\Paymentscapture\Model\CaptureFactory
     */
    private $capturer;
    
    /**
     *
     * @var \Magento\Framework\App\State 
     */
    private $state;

    /**
     * CaptureCommand constructor.
     * @param \FiloBlu\Paymentscapture\Model\CaptureFactory $capturer
     * @param \Magento\Framework\App\State $state
     */
    public function __construct(
            \FiloBlu\Paymentscapture\Model\CaptureFactory $capturer,
            \Magento\Framework\App\State $state
            )
    {
        $this->capturer = $capturer;
        $this->state = $state;
        parent::__construct();
    }
 
    protected function configure()
    {
        $this->setName('filoblu:paymentscapture:capture')->setDescription('Capture pending payments based on configuration parameters');
    }
 
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_ADMINHTML);
        } catch (\Exception $e) {
            //noop: area code already set
        }
        $this->capturer->create()->capture();
    }
 
}