<?php


namespace FiloBlu\PaymentMethodFilter\Plugin\Magento\GiftCardAccount\Model\Service;



class GiftCardAccountManagement
{
    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;

    /**
     * @var \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter
     */
    protected $helper;

    /**
     * @param \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
     * @param \Magento\GiftCardAccount\Helper\Data $giftCardHelper
     * @param \Magento\GiftCardAccount\Model\GiftcardaccountFactory $giftCardAccountFactory
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param GiftCardAccountManagerInterface|null $manager
     * @param GiftCardAccountRepositoryInterface|null $repo
     * @param CustomerBalanceHelper|null $customerBalance
     * @param SearchCriteriaBuilder|null $criteriaBuilder
     */
    public function __construct(
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository,
        \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter $helper
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->helper = $helper;
    }

    public function beforeSaveByQuoteId(
        \Magento\GiftCardAccount\Model\Service\GiftCardAccountManagement $subject,
        $cartId,
        \Magento\GiftCardAccount\Api\Data\GiftCardAccountInterface $giftCardAccountData
    ) {
        /** @var  \Magento\Quote\Model\Quote $quote */
        $quote = $this->quoteRepository->getActive($cartId);
        if ($this->helper->isGiftcardBuyingPrevented() && $quote && $this->helper->quoteContainsGiftcard($quote)) {
            throw new \Magento\Framework\Exception\LocalizedException(__('Sorry, you cannot buy a gift card using a gift card.'));
        }
        return null;
    }
}