<?php


namespace FiloBlu\PaymentMethodFilter\Observer\Checkout;

class CartProductAddBefore implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter
     */
    protected $helper;

    /**
     * @var \Magento\Quote\Api\CartRepositoryInterface
     */
    protected $quoteRepository;

    public function __construct(
        \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter $helper,
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
)
    {
        $this->helper = $helper;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * Prevent adding a gift card if I am paying with a gift card.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    ) {
        if (!$this->helper->isGiftcardBuyingPrevented()) {
            return;
        }

        $items = $observer->getData('items');
        $quote = null;
        foreach ($items as $item)
        {
            if (is_null($quote)) {
                $quote = $this->quoteRepository->getActive($item->getData('quote_id'));
            }

            if($this->helper->isPayingWithGiftcard($quote) && $item->getData('product_type') == 'giftcard') {
                throw new \Magento\Framework\Exception\LocalizedException(__('Sorry, you cannot buy a gift card using a gift card.'));
            }
        }
    }
}
