<?php


namespace FiloBlu\PaymentMethodFilter\Observer\Checkout;

class SubmitBefore implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @var \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter
     */
    protected $helper;

    public function __construct(
        \FiloBlu\PaymentMethodFilter\Helper\PaymentFilter $helper) {
        $this->helper = $helper;
    }

    /**
     * Prevent placing an order containing a gift card, paid with a gift card.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(
        \Magento\Framework\Event\Observer $observer
    ) {
        if ($this->helper->isGiftcardBuyingPrevented() && $this->helper->isPayingWithGiftcard($observer->getQuote()) && $this->helper->quoteContainsGiftcard($observer->getQuote())) {
            throw new \Magento\Framework\Exception\LocalizedException(__('Sorry, you cannot buy a gift card using a gift card.'));
        }
    }
}