<?php


namespace FiloBlu\PaymentMethodFilter\Model\Config\Source;

use FiloBlu\PaymentMethodFilter\Helper\PaymentFilter;

class FilterCondition implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var PaymentFilter
     */
    protected $helper;

    public function __construct(
        PaymentFilter $helper
    ) {
        $this->helper = $helper;
    }

    public function toOptionArray()
    {
        $result = [
            ['value' => '*', 'label' => __('- Any -')],
            ['value' => 'giftcard', 'label' => __('Gift Card in Cart')],
            ['value' => 'products', 'label' => __('Products in Cart')],
            ['value' => 'product_custom_options', 'label' => __('Product Custom Options in Cart')],
            ['value' => 'product_attributes', 'label' => __('Product Attributes in Cart')],
        ];

        if($this->helper->existsSubscriptionsClass()) {
            $result[] = ['value' => 'product_subscriptions', 'label' => __('Products in subscriptions in Cart')];
        }

        return $result;
    }

    public function toArray()
    {
        return ['*' => __('- Any -'), 'giftcard' => __('Gift Card in Cart'), 'products' => __('Products in Cart'), 'product_custom_options' => __('Product Custom Options in Cart'), 'product_attributes' => __('Product Attributes in Cart')];
    }
}
