<?php

namespace FiloBlu\PaymentMethodFilter\Model\Config\Source;

class Allmethods implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * Payment data
     *
     * @var \Magento\Payment\Helper\Data
     */
    protected $_paymentData;

    /**
     * @param \Magento\Payment\Helper\Data $paymentData
     */
    public function __construct(\Magento\Payment\Helper\Data $paymentData)
    {
        $this->_paymentData = $paymentData;
    }

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        $data = $this->_paymentData->getPaymentMethodList(true, true, true);

        $refiloPayments = [
            'adyen_bankTransfer_IBAN' => [
                'value' => 'adyen_bankTransfer_IBAN',
                'label' => 'Adyen BankTransfer IBAN'
            ],
            'adyen_paypal' => [
                'value' => 'adyen_paypal',
                'label' => 'Adyen PayPal'
            ],
            'adyen_paywithgoogle' => [
                'value' => 'adyen_paywithgoogle',
                'label' => 'Adyen Google Pay'
            ],
            'adyen_applepay' => [
                'value' => 'adyen_applepay',
                'label' => 'Adyen Apple Pay'
            ],
            'adyen_paysafecard' => [
                'value' => 'adyen_paysafecard',
                'label' => 'Adyen Pay Safe Card'
            ],
            'adyen_sepadirectdebit' => [
                'value' => 'adyen_sepadirectdebit',
                'label' => 'Adyen Sepa Direct Debit'
            ],
            'adyen_alipay' => [
                'value' => 'adyen_alipay',
                'label' => 'Adyen AliPay'
            ],
            'adyen_bankTransfer_IT' => [
                'value' => 'adyen_bankTransfer_IT',
                'label' => 'Adyen BankTransfer IT'
            ],
            'adyen_ideal' => [
                'value' => 'adyen_ideal',
                'label' => 'Adyen iDEAL'
            ],
            'adyen_multibanco' => [
                'value' => 'adyen_multibanco',
                'label' => 'Adyen Multibanco'
            ],
            'adyen_blik' => [
                'value' => 'adyen_blik',
                'label' => 'Adyen Blik'
            ],
            'adyen_dotpay' => [
                'value' => 'adyen_dotpay',
                'label' => 'Adyen Dotpay'
            ],
            'adyen_klarna' => [
                'value' => 'adyen_klarna',
                'label' => 'Adyen Klarna Pay Later'
            ],
            'adyen_klarna_paynow' => [
                'value' => 'adyen_klarna_paynow',
                'label' => 'Adyen Klarna Pay Now'
            ],
            'adyen_klarna_account' => [
                'value' => 'adyen_klarna_account',
                'label' => 'Adyen Klarna Pay Over Time'
            ],
            'adyen_bank_ru' => [
                'value' => 'adyen_bank_ru',
                'label' => 'Adyen Bank RU'
            ],
            'adyen_c_cash' => [
                'value' => 'adyen_c_cash',
                'label' => 'Adyen C Cash'
            ],
            'adyen_online_RU' => [
                'value' => 'adyen_online_RU',
                'label' => 'Adyen Online RU'
            ],
            'adyen_terminal_RU' => [
                'value' => 'adyen_terminal_RU',
                'label' => 'Adyen Terminal RU'
            ],
            'adyen_unionpay' => [
                'value' => 'adyen_unionpay',
                'label' => 'Adyen Union Pay'
            ],
            'adyen_wallet_RU' => [
                'value' => 'adyen_wallet_RU',
                'label' => 'Adyen Wallet RU'
            ],
            'klarna_pay_later' => [
                'value' => 'klarna_pay_later',
                'label' => 'Klarna Pay Later'
            ],
            'klarna_pay_over_time' => [
                'value' => 'klarna_pay_over_time',
                'label' => 'Klarna Pay Over Time'
            ],
            'klarna_direct_bank_transfer' => [
                'value' => 'klarna_direct_bank_transfer',
                'label' => 'Klarna Direct Bank Transfer'
            ],
            'klarna_direct_debit' => [
                'value' => 'klarna_direct_debit',
                'label' => 'Klarna Direct Debit'
            ],
            'klarna_pay_now' => [
                'value' => 'klarna_pay_now',
                'label' => 'Klarna Pay Now'
            ]
        ];

        $data['refilo_payments'] = [
            'value' => $refiloPayments,
            'label' => 'Refilo Payments'
        ];

        return $data;
    }
}
