<?php

  namespace FiloBlu\PaymentMethodFilter\Block\Adminhtml\System\Config;

  use Magento\Backend\Block\Template\Context;
  use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
  use Magento\Framework\DataObject;
  use Magento\Framework\Exception\LocalizedException;

  class MappingFields extends AbstractFieldArray
  {

    /**
     * @var CollectionFactory
     */
    protected $_websitesCollection;
    /**
     * @var Collection
     */
    protected $_channelCollection;
    /**
     * @var null
     */
    protected $_websitesRenderer;

    protected $shippingAllmethods;

    protected $allPaymentMethod;

    /**
     * MappingFields constructor.
     * @param Context $context
     * @param CollectionFactory $collection
     * @param Collection $channel_collection
     * @param array $data
     */
    public function __construct(
      Context $context,
      \Magento\Shipping\Model\Config\Source\Allmethods $shippingAllmethods,
      \FiloBlu\PaymentMethodFilter\Model\Config\Source\Allmethods $allPaymentMethod,
      array $data = []
    ) {
      $this->shippingAllmethods = $shippingAllmethods;
      $this->allPaymentMethod = $allPaymentMethod;
      parent::__construct($context, $data);
    }


    public function getAllShippingMethods()
    {
      $allShipping = $this->shippingAllmethods->toOptionArray();

      return $allShipping;
    }

    public function getPaymentsRenderer()
    {
      $allPayments = $this->allPaymentMethod->toOptionArray();
      array_unshift($allPayments, ['value' => '', 'label' => __('-- Select --')]);

      $paymentsRenderer = $this->getLayout()->createBlock(
        'Magento\Framework\View\Element\Html\Select',
        '',
        ['data' => ['is_render_to_js_template' => true]]
      )
        ->setId($this->_getCellInputElementId('<%- _id %>', 'payment_code_filter'))
        ->setName($this->_getCellInputElementName('payment_code_filter') . "[]")
        ->setClass('multiselect')
        ->setOptions($allPayments)
        ->setExtraParams('style="width:220px" multiple="multiple" size="5" ');

      return $paymentsRenderer;
    }

    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
      $allShipping = $this->getAllShippingMethods();
      array_unshift($allShipping, ['value' => '', 'label' => __('-- Select --')]);

      $shippingBlock=$this->getLayout()->createBlock('Magento\Framework\View\Element\Html\Select')
        ->setId($this->_getCellInputElementId('<%- _id %>', 'shipping_code_filter'))
        ->setName($this->_getCellInputElementName('shipping_code_filter'))
        ->setClass('select')
        ->setOptions($allShipping);

      $this->addColumn('shipping_code_filter', [
        'label' => __('Shipping Method'),
        'renderer' => $shippingBlock
      ]);

      $paymentsBlock=$this->getPaymentsRenderer();
      $this->addColumn('payment_code_filter', [
        'label' => __('Payments methods'),
        'renderer' => $paymentsBlock
      ]);

      $this->_addAfter = false;
      $this->_addButtonLabel = __('Add');
    }

    /**
     * @param DataObject $row
     * @throws LocalizedException
     */
    protected function _prepareArrayRow(DataObject $row)
    {
      $renderer = $this->getPaymentsRenderer();

      $column_values=$row->getColumnValues();
      unset($column_values[$row->getData('_id') . '_payment_code_filter']);
      $row->setData('column_values', $column_values);

      //Set selected values for multiselect using option_extra_attrs
      $payments = $row->getPayment_code_filter();
      if ($payments) {
        $options = [];
        foreach ($payments as $payment) {
          $options['option_' . $renderer->calcOptionHash($payment)]
            = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
      }
    }

  }
