# Magento 2 Module FiloBlu OrderFlowRectifier

    filoblu/mod2-order-flow-rectifier

 - [Main Functionalities](#markdown-header-main-functionalities)
 - [Configuration](#markdown-header-configuration)
 - [Console commands](#markdown-header-console-commands)
 - [Specifications](#markdown-header-specifications)


## Main Functionalities

Fixes stuck orders by fixing status, payment information or other order data.

### Cron job and CLI rectifiers ###

A rectifier has been developed for each of the following use case:

 - Ordine adyen fermo in order exported, mancano i dati del pagamento (MissingPaymentInfoRectifier)
 
 - Ordine adyen fermo in order exported. Lo state dell’ordine è rimasto in payment_review, oppure lo status semplicemente non è aggiornato. (PaymentReviewRectifier)
 
 - Ordine adyen fermo in order exported. Lo status è corretto, ma lo state è rimasto payment_review invece di passare a processing (PaymentReviewStateRectifier)
 
 - Invoice creata ma ordine non modificato nei campi “invoiced”, "paid" e "due". (InvoicedRectifier)
 
 - Ordine rimasto shipped, mentre dovrebbe essere complete. Tutti gli item sono invoiced e shipped. (ShippedRectifier)
 
 - Gestione mail di conferma per gli ordini effettuati negli ultimi 2 giorni con i metodi di pagamento definiti, con lo status fino a 'send_to_logistic' e nei quali la mail non è ancora stata inviata. (SendEmailOrderConfirmationRectifier)
 
 - Status ordine non allineato alla history aggiornata a order_exported. Allineamento status a order_exported. (OrderExportedStatusUpdateRectifier)
 
 - Ordine rimasto in processing mentre la history è aggiornata a confirmed e il metodo di pagamento è PayPal. Allineamento status a confirmed. (ConfirmedStatusUpdateRectifier)
 
 - Inserimento dati in ESB per sistemare gli ordini che hanno avuto problemi con i cambi di stato. (EsbScheduleUpdateRectifier)
   
 - Ordini bloccati in order exported che non riescono a cambiare stato in quanto mancano informazioni relative alla transazione; recupero e aggiornamento di tali info. (OrderPaymentDataIncompleteRectifier)
   
 - Ordini tornati indietro da order exported a confirmed con la notifica RECURRING_CONTRACT di adyen. (OrderExportedBackToConfirmedRectifier)

 - Gestione ordini fatti con Klarna. Recupero dati mancati relativi alla transazione adyen e correzione dello state per ordini fermi in order exported. (KlarnaOrderRectifier)

 - Elimina ordini fatti con Klarna fermi in pending e senza pagamento creato su adyen, quindi senza adyen_notification. (ClearKlarnaOrderRectifier)

 - Eliminazione ordini fatti dal bot dei test automatici, riconosciuti dall'indirizzo email sistemi@filoblu.com. (ClearTestOrderRectifier)

 - Elimina ordini fatti con PayPal via Adyen fermi in pending e senza pagamento creato su adyen, quindi senza adyen_notification o senza authorisation. (ClearPayPalHppOrderRectifier)

 - Recupero e aggiornamento informazioni mancati relative alla transazione di adyen per gli ordini di tipo adyen_hpp. (OrderAdyenHppPaymentDataIncompleteRectifier)

 - Elimina ordini fatti con PayPal Express Checkout fermi in processing e con lo status history sempre in processing come ultimo status, quindi non c'è stato cambio di stato poichè non esiste il pagamento su paypal. (ClearPayPalExpressOrderRectifier)

 - Aggiornamento dettagli ordini Klarna Payments, aggiunta la tipologia del prodotto. (CompleteKlarnaPaymentsDetailsRectifier)
 
 - Riprocessa la adyen notification per aggiornare i dati di pagamento per gli ordini fatti con paypal tramite adyen. (FixPayPalHppPaymentInfoRectifier)

 - Sistemare cc_type indicati come Klarna via adyen per altri metodi di pagamento. (FixFakeAdyenKlarnaCcType)

 - Pulire il campo additional data da eventuali method_code klarna per ordini fatti con altri metodi di pagamento. (ClearPaymentAdditionlInfoRectifier)

 - Bonifica campo state da new a canceled per gli ordini cancellati. (StateFixForCanceledOrders)


 Rectifiers should be scheduled and ran regularly.
 
### Observer-based rectifiers ###

 The "Enable fix for missing cc_type" option, if activated, checks the orders placed by credit card and if cc_type is missing, it retrieves it from adyen_notification and saves it in sales_order_payment.

 The "Enable check for invoice creation" option, if activated, it checks that the payment details are present to create the invoice and do the capture. If incomplete, the creation of the invoice is blocked.

The "Enable cancellation of orders placed with klarna and with payment refused" option, if activated, it deletes the orders placed with Klarna if the payment has been Refused (adyen notification returns false).


## Configuration

 - Enable Scheduled Operations (order_flow_rectifier/general/scheduled_ops_enabled) 

 - Enabled rectifiers (order_flow_rectifier/general/enabled_rectifiers)
 
 - Enable fix for missing cc_type (order_flow_rectifier/general/scheduled_cctype_check_enabled)


## Console commands ##

- `filoblu:orderflowrectifier:list `

- `filoblu:orderflowrectifier:process [-d|--dry-run] [-o|--order="..."] [rectifier]`

## Specifications

 - Cronjob
	- `filoblu_orderflowrectifier_rectifier`
