<?php

namespace FiloBlu\OrderFlowRectifier\Plugin\Magento\Backend\Block\Widget;


use FiloBlu\OrderFlowRectifier\Helper\AdyenBankTransferHelper;
use Magento\Backend\Block\Widget\Context as WidgetContext;
use Magento\Backend\Block\Widget\Button\ButtonList;
use Magento\Framework\App\Action\Context as ActionContext;
use Magento\Framework\AuthorizationInterface;
use Magento\Framework\Registry;

class Context
{
    /**
     * @var ActionContext
     */
    protected $context;

    /**
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var AdyenBankTransferHelper
     */
    protected $helper;

    /**
     * @var AuthorizationInterface
     */
    private $authorization;

    public function __construct(
        ActionContext $context,
        Registry $registry,
        AdyenBankTransferHelper $helper,
        AuthorizationInterface $authorization
    )
    {
        $this->context = $context;
        $this->coreRegistry = $registry;
        $this->urlBuilder = $context->getUrl();
        $this->helper = $helper;
        $this->authorization = $authorization;
    }

    public function afterGetButtonList(
        WidgetContext $subject,
        ButtonList $buttonList
    )
    {
        $request = $this->context->getRequest();
        if($request->getFullActionName() == 'sales_order_view') {
            $order = $this->getCurrentOrder();
            $payment = $order->getPayment();
            $orderStatus = $this->helper->manualReminderButtonOrderStatus();
            if($this->helper->manualReminderButtonIsEnabled() &&
                ($payment->getMethod() == 'adyen_bankTransfer_IBAN' ||
                    ($payment->getMethod() == 'adyen_hpp' && $payment->getCcType() == 'bankTransfer_IBAN')) &&
                !empty($orderStatus) && in_array($order->getStatus(), $orderStatus) &&
                $this->authorization->isAllowed('FiloBlu_OrderFlowRectifier::config_filoblu_orderflowrectifier_manual_reminder_button')) {

                $message = __('Do you confirm sending the payment reminder for this order?');
                $url = $this->urlBuilder->getUrl('filobluorderflowrectifier/Order/SendPaymentReminder', ['order_id' => $order->getId()]);
                $buttonList->add(
                    'payment_reminder',
                    [
                        'label' => __('Send Payment Reminder'),
                        'onclick' => "confirmSetLocation('{$message}', '{$url}')"
                    ]
                );
            }
        }

        return $buttonList;
    }

    /**
     * @return \Magento\Sales\Model\Order|null
     */
    public function getCurrentOrder()
    {
        return $this->coreRegistry->registry('current_order');
    }
}

