<?php

namespace FiloBlu\OrderFlowRectifier\Observer\Sales;

use Magento\Framework\Event\Observer;

class OrderPlaceBefore extends OrderPlaceBeforeAbstract
{
    public function execute(Observer $observer)
    {
        if($this->dataHelper->checkQuoteItemIsEnabled())
        {
            $missingQuoteItem = $this->checkQuote($observer);

            if(!empty($missingQuoteItem))
            {
                $this->logger->observerLog('QUOTE ID -> '.$missingQuoteItem['quote_id']);
                $logString = '';
                $productName = array();
                foreach ($missingQuoteItem['item_data'] as $item)
                {
                    $logString.= 'PRODUCT ITEM '.$item['item_id'].' & SKU '.$item['sku'].' & PRODUCT ID '.$item['product_id'].' // ';
                    if($item['product_name'] != '')
                    {
                        $productName[] = $item['product_name'];
                    }
                }
                $this->logger->observerLog('Log Observer OrderPlaceBefore');
                $this->logger->observerLog($logString);
                $this->logger->observerLog(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 20));
                $this->dataHelper->sendNotificationMail($missingQuoteItem, 'Place order');

                $errorString = 'It is not possible to complete the order due to problems with some products.';
                if(!empty($productName))
                {
                    $errorString = 'It is not possible to complete the order due to problems with the following products: "'.implode(' / ', $productName).'". ';
                    $errorString.= 'Please remove and add them again.';
                }

                throw new \Magento\Framework\Exception\LocalizedException(__($errorString));
            }
        }
    }
}
