<?php

namespace FiloBlu\OrderFlowRectifier\Observer\Sales;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Store\Model\ScopeInterface;

class OrderPlaceAfter implements ObserverInterface
{
    const ADYEN_EMAIL_CONFIGURATIONS_CONFIG_PATH = 'order_flow_rectifier/adyen_email_configurations/adyen_email_configurations_enabled';

    /** @var ScopeConfigInterface */
    protected $scopeConfig;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    public function execute(Observer $observer)
    {
        $order = $observer->getOrder();
        if ($this->scopeConfig->isSetFlag(self::ADYEN_EMAIL_CONFIGURATIONS_CONFIG_PATH, ScopeInterface::SCOPE_STORE, $order->getStoreId())) {
            $orderPayment = $order->getPayment();
            if (($orderPayment->getMethod() == 'adyen_hpp' && $orderPayment->getCcType() == 'multibanco')
                || $orderPayment->getMethod() == 'adyen_multibanco') {
                // For multibanco only, set send_email to true to allow sending new custom mail with payment information details
                $order->setSendEmail(true);
            }
        }

        return true;
    }
}
