<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use FiloBlu\OrderFlowRectifier\Helper\Data;
use Magento\Email\Model\BackendTemplate;
use Magento\Framework\App\Area;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Store\Model\Store;

class NotifyBankTransferAuthorization implements ObserverInterface
{
    const NOTIFY_BANK_TRANSFER_AUTH_EMAIL_TEMPLATE = 'notify_bank_transfer_authorisation';
    const METHOD_TO_CHECK = ['bankTransfer_IBAN', 'multibanco'];
    const STATUS_TO_CHECK = ['canceled', 'closed'];

    /**
     * @var Data
     */
    protected $dataHelper;

    /**
     * @var TransportBuilder
     */
    private $transportBuilder;

    public function __construct(
        Data             $dataHelper,
        TransportBuilder $transportBuilder
    )
    {
        $this->dataHelper = $dataHelper;
        $this->transportBuilder = $transportBuilder;
    }

    public function execute(Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $notificationRecipients = $this->dataHelper->getBankTransferAuthNotificationRecipientsArray();

        if (!$this->dataHelper->bankTransferAuthNotificationIsEnabled()
            || $observer->getEvent()->getNotificationCode() != 'AUTHORISATION'
            || !in_array($observer->getEvent()->getPaymentMethod(), self::METHOD_TO_CHECK)
            || !in_array($order->getStatus(), self::STATUS_TO_CHECK)
            || empty($notificationRecipients)) {
            return;
        }

        $transport = $this->transportBuilder->setTemplateIdentifier(
            self::NOTIFY_BANK_TRANSFER_AUTH_EMAIL_TEMPLATE
        )
            ->setTemplateModel(BackendTemplate::class)
            ->setTemplateOptions([
                    'area' => Area::AREA_ADMINHTML,
                    'store' => Store::DEFAULT_STORE_ID
                ]
            )
            ->setTemplateVars([
                'orderid' => $order->getIncrementId()
            ])
            ->setFromByScope([
                'email' => $this->dataHelper->emailSender(),
                'name' => $this->dataHelper->nameSender()
            ])
            ->addTo($notificationRecipients)
            ->getTransport();

        $transport->sendMessage();
    }
}
