<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use FiloBlu\OrderFlowRectifier\Helper\Data;
use FiloBlu\OrderFlowRectifier\Helper\OrderFlowLogger;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Api\CartRepositoryInterface;

/**
 * Observer on order place before and set cc_type at null if current payment metodh is selected in the backend list.
 * This is used to clear cc_type from payment methods that don't have it but which it is still set due to click on the different methods at checkout.
 */
class FixQuoteCCType implements ObserverInterface
{
    /**
     * @var ScopeConfigInterface
     */
    protected $config;

    /**
     * @var CartRepositoryInterface
     */
    protected $quoteRepository;

    /**
     * @var OrderFlowLogger
     */
    protected $logger;

    public function __construct(
        ScopeConfigInterface    $config,
        CartRepositoryInterface $quoteRepository,
        OrderFlowLogger         $logger
    )
    {
        $this->config = $config;
        $this->quoteRepository = $quoteRepository;
        $this->logger = $logger;
    }

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        if ($this->config->isSetFlag(Data::QUOTE_CCTYPE_ENABLED_CONFIG_PATH)) {
            $paymentMethodToFix = explode(",", $this->config->getValue(Data::QUOTE_CCTYPE_PAYMENT_METHOD_TO_FIX_CONFIG_PATH, \Magento\Store\Model\ScopeInterface::SCOPE_STORE));
            $otherPaymentMethodToFix = $this->config->getValue(Data::QUOTE_CCTYPE_OTHER_PAYMENT_METHOD_TO_FIX_CONFIG_PATH, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $order = $observer->getEvent()->getOrder();
            $orderPayment = $order->getPayment();
            $method = $orderPayment->getMethod();
            if (in_array($method, $paymentMethodToFix) || preg_match($otherPaymentMethodToFix, $method)) {
                if (!is_null($order->getQuoteId())) {
                    try {
                        $quote = $this->quoteRepository->get($order->getQuoteId());
                        $quotePayment = $quote->getPayment();
                        $quotePayment->setCcType(null);
                    } catch (\Exception $e) {
                        $this->logger->observerLog('Log Observer FixQuoteCCType');
                        $this->logger->observerLog('Quote missing -> '.$e->getMessage());
                    }
                }
                $orderPayment->setCcType(null);
            }
        }

        return TRUE;
    }
}
