<?php

namespace FiloBlu\OrderFlowRectifier\Observer;

use FiloBlu\OrderFlowRectifier\Helper\Data;
use FiloBlu\OrderFlowRectifier\Helper\OrderFlowLogger;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class CheckQuoteItemAddAfter implements ObserverInterface
{
    protected $dataHelper;
    protected $logger;

    public function __construct(
        Data $dataHelper,
        OrderFlowLogger $logger
    ) {
        $this->dataHelper = $dataHelper;
        $this->logger = $logger;
    }

    public function execute(Observer $observer)
    {
        if($this->dataHelper->checkQuoteItemIsEnabled())
        {
            $quote = $observer->getEvent()->getCart()->getQuote();
            $quoteId = $quote->getId();

            $quoteItem = $this->dataHelper->getQuoteItem($quoteId);
            $missingItem = $this->dataHelper->checkQuoteItem($quoteItem, $quoteId);

            if(!empty($missingItem))
            {
                $this->logger->observerLog('Log Observer CheckQuoteItemAddAfter');
                $this->logger->observerLog('QUOTE ID -> '.$missingItem['quote_id']);
                $logString = '';
                $itemIdToDelete = array();
                $productName = array();
                foreach ($missingItem['item_data'] as $item)
                {
                    $logString.= 'PRODUCT ITEM '.$item['item_id'].' & SKU '.$item['sku'].' & PRODUCT ID '.$item['product_id'].' // ';
                    $itemIdToDelete[] = $item['item_id'];
                    if($item['product_name'] != '')
                    {
                        $productName[] = $item['product_name'];
                    }
                }
                $this->logger->observerLog($logString);
                $this->logger->observerLog(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 20));
                $this->dataHelper->sendNotificationMail($missingItem,'Add to cart');

                $errorString = 'Problems have been detected with some cart products. ';
                if(!empty($productName))
                {
                    $errorString = 'Problems have been detected with cart products: "'.implode(' / ', $productName).'". ';
                }

                if($this->dataHelper->deleteQuoteItemIsEnabled() && !empty($itemIdToDelete))
                {
                    foreach ($itemIdToDelete as $itemId)
                    {
                        $this->dataHelper->deleteQuoteItem($quoteId, $itemId);
                    }
                    $errorString.= "These products have been removed from the cart. Please add them again.";
                }
                else
                {
                    $errorString.= "Please remove and add them again.";
                }

                throw new \Magento\Framework\Exception\LocalizedException(__($errorString));
            }
        }
    }
}
